/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.core.lib.engines.TileEngineWithInventory;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.energy.TileEngineStone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEngine
extends BuildCraftContainer {
    protected TileEngineWithInventory engine;

    public ContainerEngine(InventoryPlayer inventoryplayer, TileEngineWithInventory tileEngine) {
        super(tileEngine.getSizeInventory());
        this.engine = tileEngine;
        if (tileEngine instanceof TileEngineStone) {
            this.addSlotToContainer(new Slot((IInventory)tileEngine, 0, 80, 41));
        } else {
            this.addSlotToContainer(new Slot((IInventory)tileEngine, 0, 52, 41));
        }
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            this.engine.sendGUINetworkData(this, (ICrafting)crafter);
        }
    }

    public void updateProgressBar(int i, int j) {
        this.engine.getGUINetworkData(i, j);
    }

    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return this.engine.isUseableByPlayer(entityplayer);
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.engine.isUseableByPlayer(entityplayer);
    }
}

