/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class StatementParameterItemStackExact
implements IStatementParameter {
    protected ItemStack stack;
    private int availableSlots;

    public StatementParameterItemStackExact() {
        this(-1);
    }

    public StatementParameterItemStackExact(int availableSlots) {
        this.availableSlots = availableSlots;
    }

    @Override
    public IIcon getIcon() {
        return null;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        if (stack != null) {
            if (this.areItemsEqual(this.stack, stack)) {
                if (mouse.getButton() == 0) {
                    int maxSize;
                    this.stack.stackSize = this.stack.stackSize + (mouse.isShift() ? 16 : 1);
                    int n = maxSize = this.availableSlots < 0 ? 64 : Math.min(64, this.stack.getMaxStackSize() * this.availableSlots);
                    if (this.stack.stackSize > maxSize) {
                        this.stack.stackSize = maxSize;
                    }
                } else {
                    this.stack.stackSize = this.stack.stackSize - (mouse.isShift() ? 16 : 1);
                    if (this.stack.stackSize <= 0) {
                        this.stack = null;
                    }
                }
            } else {
                this.stack = stack.copy();
            }
        } else if (this.stack != null) {
            if (mouse.getButton() == 0) {
                int maxSize;
                this.stack.stackSize = this.stack.stackSize + (mouse.isShift() ? 16 : 1);
                int n = maxSize = this.availableSlots < 0 ? 64 : Math.min(64, this.stack.getMaxStackSize() * this.availableSlots);
                if (this.stack.stackSize > maxSize) {
                    this.stack.stackSize = maxSize;
                }
            } else {
                this.stack.stackSize = this.stack.stackSize - (mouse.isShift() ? 16 : 1);
                if (this.stack.stackSize <= 0) {
                    this.stack = null;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        if (this.stack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.stack.writeToNBT(tagCompound);
            compound.setTag("stack", (NBTBase)tagCompound);
        }
        compound.setInteger("availableSlots", this.availableSlots);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        if (compound.hasKey("availableSlots")) {
            this.availableSlots = compound.getInteger("availableSlots");
        }
        this.stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("stack"));
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterItemStackExact) {
            StatementParameterItemStackExact param = (StatementParameterItemStackExact)object;
            return this.areItemsEqual(this.stack, param.stack);
        }
        return false;
    }

    private boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null) {
            return stack2 != null && stack1.isItemEqual(stack2) && ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
        }
        return stack2 == null;
    }

    @Override
    public String getDescription() {
        if (this.stack != null) {
            return this.stack.getDisplayName();
        }
        return "";
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:stackExact";
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }
}

