/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.statements.containers.ISidedStatementContainer;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.statements.StatementParameterRedstoneGateSideOnly;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionRedstoneOutput
extends BCStatement
implements IActionInternal {
    public ActionRedstoneOutput(String s) {
        super(s);
    }

    public ActionRedstoneOutput() {
        super("buildcraft:redstone.output", "buildcraft.redstone.output");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.redstone.signal");
    }

    @Override
    public IStatementParameter createParameter(int index) {
        StatementParameterRedstoneGateSideOnly param = null;
        if (index == 0) {
            param = new StatementParameterRedstoneGateSideOnly();
        }
        return param;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    protected boolean isSideOnly(IStatementParameter[] parameters) {
        if (parameters != null && parameters.length >= 1 && parameters[0] instanceof StatementParameterRedstoneGateSideOnly) {
            return ((StatementParameterRedstoneGateSideOnly)parameters[0]).isOn;
        }
        return false;
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
        if (source instanceof IRedstoneStatementContainer) {
            ForgeDirection side = ForgeDirection.UNKNOWN;
            if (source instanceof ISidedStatementContainer && this.isSideOnly(parameters)) {
                side = ((ISidedStatementContainer)source).getSide();
            }
            ((IRedstoneStatementContainer)((Object)source)).setRedstoneOutput(side, this.getSignalLevel());
        }
    }

    protected int getSignalLevel() {
        return 15;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = register.registerIcon("buildcraftcore:triggers/action_redstoneoutput");
    }
}

