/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.proxy;

import buildcraft.BuildCraftCore;
import buildcraft.core.LaserKind;
import buildcraft.core.RenderPathMarker;
import buildcraft.core.TilePathMarker;
import buildcraft.core.lib.EntityBlock;
import buildcraft.core.lib.engines.RenderEngine;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.render.RenderBlockComplex;
import buildcraft.core.lib.render.RenderEntityBlock;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.render.RenderingEntityBlocks;
import buildcraft.core.render.RenderingMarkers;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public class CoreProxyClient
extends CoreProxy {
    @Override
    public Object getClient() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().theWorld;
    }

    @Override
    public void removeEntity(Entity entity) {
        super.removeEntity(entity);
        if (entity.worldObj.isRemote) {
            ((WorldClient)entity.worldObj).removeEntityFromWorld(entity.getEntityId());
        }
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        if (stack.getItem() == null) {
            return "";
        }
        return stack.getDisplayName();
    }

    @Override
    public void initializeRendering() {
        BuildCraftCore.blockByEntityModel = RenderingRegistry.getNextAvailableRenderId();
        BuildCraftCore.markerModel = RenderingRegistry.getNextAvailableRenderId();
        BuildCraftCore.complexBlockModel = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderingEntityBlocks());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderingMarkers());
        RenderingRegistry.registerBlockHandler((int)BuildCraftCore.complexBlockModel, (ISimpleBlockRenderingHandler)new RenderBlockComplex());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePathMarker.class, (TileEntitySpecialRenderer)new RenderPathMarker());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineBase.class, (TileEntitySpecialRenderer)new RenderEngine());
        for (int i = 0; i < 16; ++i) {
            if (!BuildCraftCore.engineBlock.hasEngine(i)) continue;
            TileEngineBase engineTile = (TileEngineBase)BuildCraftCore.engineBlock.createTileEntity(null, i);
            engineTile.blockType = BuildCraftCore.engineBlock;
            engineTile.blockMetadata = i;
            RenderingEntityBlocks.blockByEntityRenders.put(new RenderingEntityBlocks.EntityRenderIndex((Block)BuildCraftCore.engineBlock, i), new RenderEngine(engineTile));
        }
    }

    @Override
    public void initializeEntityRendering() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBlock.class, (Render)RenderEntityBlock.INSTANCE);
    }

    @Override
    public String playerName() {
        return FMLClientHandler.instance().getClient().thePlayer.getDisplayName();
    }

    @Override
    public EntityBlock newEntityBlock(World world, double i, double j, double k, double iSize, double jSize, double kSize, LaserKind laserKind) {
        EntityBlock eb = super.newEntityBlock(world, i, j, k, iSize, jSize, kSize, laserKind);
        switch (laserKind) {
            case Blue: {
                eb.setTexture(BuildCraftCore.blueLaserTexture);
                break;
            }
            case Red: {
                eb.setTexture(BuildCraftCore.redLaserTexture);
                break;
            }
            case Stripes: {
                eb.setTexture(BuildCraftCore.stripesLaserTexture);
            }
        }
        return eb;
    }

    @Override
    public EntityPlayer getPlayerFromNetHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).playerEntity;
        }
        return Minecraft.getMinecraft().thePlayer;
    }

    @Override
    public TileEntity getServerTile(TileEntity source) {
        TileEntity t;
        Chunk c;
        WorldServer w;
        if (BuildCraftCore.useServerDataOnClient && Minecraft.getMinecraft().isSingleplayer() && source.getWorldObj().isRemote && (w = DimensionManager.getWorld((int)source.getWorldObj().provider.dimensionId)) != null && w.getChunkProvider() != null && (c = w.getChunkFromBlockCoords(source.xCoord, source.zCoord)) != null && (t = c.getTileEntityUnsafe(source.xCoord & 0xF, source.yCoord, source.zCoord & 0xF)) != null && t.getClass().equals(source.getClass())) {
            return t;
        }
        return source;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.getMinecraft().thePlayer;
    }
}

