/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.properties;

import buildcraft.core.properties.ChunkProperty;
import buildcraft.core.properties.WorldProperty;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class DimensionProperty
implements IWorldAccess {
    private final LongHashMap chunkMapping = new LongHashMap();
    private final World world;
    private final int worldHeight;
    private final WorldProperty worldProperty;

    public DimensionProperty(World iWorld, WorldProperty iProp) {
        this.world = iWorld;
        this.worldHeight = iWorld.getHeight();
        this.world.addWorldAccess((IWorldAccess)this);
        this.worldProperty = iProp;
    }

    public synchronized boolean get(int x, int y, int z) {
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        if (this.world.getChunkProvider().chunkExists(xChunk, zChunk)) {
            ChunkProperty property;
            long chunkId = ChunkCoordIntPair.chunkXZ2Int((int)xChunk, (int)zChunk);
            if (!this.chunkMapping.containsItem(chunkId)) {
                property = new ChunkProperty((IBlockAccess)this.world, this.world.getHeight(), xChunk, zChunk);
                this.chunkMapping.add(chunkId, (Object)property);
                this.load(this.world.getChunkFromChunkCoords(xChunk, zChunk), property);
            } else {
                property = (ChunkProperty)this.chunkMapping.getValueByKey(chunkId);
            }
            return property.get(x & 0xF, y, z & 0xF);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Chunk chunk, ChunkProperty property) {
        World world = this.world;
        synchronized (world) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < this.worldHeight; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        Block block = chunk.getBlock(x, y, z);
                        int meta = chunk.getBlockMetadata(x, y, z);
                        boolean prop = this.worldProperty.get((IBlockAccess)this.world, block, meta, chunk.xPosition * 16 + x, y, chunk.zPosition * 16 + z);
                        property.set(x, y, z, prop);
                    }
                }
            }
        }
    }

    public synchronized void markBlockForUpdate(int x, int y, int z) {
        long chunkId;
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        if (this.world.getChunkProvider().chunkExists(xChunk, zChunk) && this.chunkMapping.containsItem(chunkId = ChunkCoordIntPair.chunkXZ2Int((int)xChunk, (int)zChunk))) {
            ChunkProperty property = (ChunkProperty)this.chunkMapping.getValueByKey(chunkId);
            Block block = this.world.getBlock(x, y, z);
            int meta = this.world.getBlockMetadata(x, y, z);
            boolean prop = this.worldProperty.get((IBlockAccess)this.world, block, meta, x, y, z);
            property.set(x & 0xF, y, z & 0xF, prop);
        }
    }

    public void markBlockForRenderUpdate(int var1, int var2, int var3) {
    }

    public void markBlockRangeForRenderUpdate(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void playSound(String var1, double var2, double var4, double var6, float var8, float var9) {
    }

    public void playSoundToNearExcept(EntityPlayer var1, String var2, double var3, double var5, double var7, float var9, float var10) {
    }

    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public void onEntityCreate(Entity var1) {
    }

    public void onEntityDestroy(Entity var1) {
    }

    public void playRecord(String var1, int var2, int var3, int var4) {
    }

    public void broadcastSound(int var1, int var2, int var3, int var4, int var5) {
    }

    public void playAuxSFX(EntityPlayer var1, int var2, int var3, int var4, int var5, int var6) {
    }

    public void destroyBlockPartially(int var1, int var2, int var3, int var4, int var5) {
    }

    public void onStaticEntitiesChanged() {
    }

    public void clear() {
        this.world.removeWorldAccess((IWorldAccess)this);
    }
}

