/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NBTUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public final class ListHandlerOld {
    private static final WeakHashMap<ItemStack, StackLine[]> LINE_CACHE = new WeakHashMap();

    private ListHandlerOld() {
    }

    public static void saveLine(ItemStack stack, StackLine line, int index) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        nbt.setBoolean("written", true);
        NBTTagCompound lineNBT = new NBTTagCompound();
        line.writeToNBT(lineNBT);
        nbt.setTag("line[" + index + "]", (NBTBase)lineNBT);
    }

    public static StackLine[] getLines(ItemStack stack) {
        if (LINE_CACHE.containsKey(stack)) {
            return LINE_CACHE.get(stack);
        }
        StackLine[] result = new StackLine[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = new StackLine();
        }
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        if (nbt.hasKey("written")) {
            for (int i = 0; i < 6; ++i) {
                result[i].readFromNBT(nbt.getCompoundTag("line[" + i + "]"));
            }
        }
        LINE_CACHE.put(stack, result);
        return result;
    }

    public static boolean matches(ItemStack stackList, ItemStack item) {
        StackLine[] lines = ListHandlerOld.getLines(stackList);
        if (lines != null) {
            for (StackLine line : lines) {
                if (line == null || !line.matches(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static class StackLine {
        public boolean oreWildcard = false;
        public boolean subitemsWildcard = false;
        public boolean isOre;
        private ItemStack[] stacks = new ItemStack[7];
        private ArrayList<ItemStack> ores = new ArrayList();
        private ArrayList<ItemStack> relatedItems = new ArrayList();

        public ItemStack getStack(int index) {
            if (index == 0 || !this.oreWildcard && !this.subitemsWildcard) {
                if (index < 7) {
                    return this.stacks[index];
                }
                return null;
            }
            if (this.oreWildcard) {
                if (this.ores.size() >= index) {
                    return this.ores.get(index - 1);
                }
                return null;
            }
            if (this.relatedItems.size() >= index) {
                return this.relatedItems.get(index - 1);
            }
            return null;
        }

        public void setStack(int slot, ItemStack stack) {
            this.stacks[slot] = stack;
            if (stack != null) {
                this.stacks[slot] = this.stacks[slot].copy();
                this.stacks[slot].stackSize = 1;
            }
            if (slot == 0) {
                this.relatedItems.clear();
                this.ores.clear();
                if (stack == null) {
                    this.isOre = false;
                } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    this.setClientPreviewLists();
                } else {
                    this.isOre = OreDictionary.getOreIDs((ItemStack)this.stacks[0]).length > 0;
                }
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.setBoolean("ore", this.oreWildcard);
            nbt.setBoolean("sub", this.subitemsWildcard);
            for (int i = 0; i < 7; ++i) {
                if (this.stacks[i] == null) continue;
                NBTTagCompound stackNBT = new NBTTagCompound();
                this.stacks[i].writeToNBT(stackNBT);
                nbt.setTag("stacks[" + i + "]", (NBTBase)stackNBT);
            }
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.oreWildcard = nbt.getBoolean("ore");
            this.subitemsWildcard = nbt.getBoolean("sub");
            for (int i = 0; i < 7; ++i) {
                if (!nbt.hasKey("stacks[" + i + "]")) continue;
                this.setStack(i, ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("stacks[" + i + "]")));
            }
        }

        private boolean classMatch(Item base, Item matched) {
            if (base.getClass() == Item.class) {
                return base == matched;
            }
            if (base.getClass() == matched.getClass()) {
                if (base instanceof ItemBlock) {
                    Block baseBlock = ((ItemBlock)base).field_150939_a;
                    Block matchedBlock = ((ItemBlock)matched).field_150939_a;
                    if (baseBlock.getClass() == Block.class) {
                        return baseBlock == matchedBlock;
                    }
                    return baseBlock.equals(matchedBlock);
                }
                return true;
            }
            return false;
        }

        private boolean oreMatch(ItemStack base, ItemStack matched) {
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)base);
            int[] matchesIds = OreDictionary.getOreIDs((ItemStack)matched);
            for (int stackId : oreIds) {
                for (int matchId : matchesIds) {
                    if (stackId != matchId) continue;
                    return true;
                }
            }
            return false;
        }

        private void setClientPreviewLists() {
            Item baseItem = this.stacks[0].getItem();
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)this.stacks[0]);
            this.isOre = oreIds.length > 0;
            for (Object o : Item.itemRegistry) {
                Item item = (Item)o;
                boolean classMatch = this.classMatch(baseItem, item);
                LinkedList list = new LinkedList();
                for (CreativeTabs tab : item.getCreativeTabs()) {
                    item.getSubItems(item, tab, list);
                }
                if (list.size() <= 0) continue;
                for (Object ol : list) {
                    ItemStack stack = (ItemStack)ol;
                    if (classMatch && this.relatedItems.size() <= 7 && !StackHelper.isMatchingItemOrList(this.stacks[0], stack)) {
                        this.relatedItems.add(stack);
                    }
                    if (!this.isOre || this.ores.size() > 7 || StackHelper.isMatchingItemOrList(this.stacks[0], stack) || !this.oreMatch(this.stacks[0], stack)) continue;
                    this.ores.add(stack);
                }
            }
        }

        public boolean matches(ItemStack item) {
            if (this.subitemsWildcard) {
                if (this.stacks[0] == null) {
                    return false;
                }
                return this.classMatch(this.stacks[0].getItem(), item.getItem());
            }
            if (this.oreWildcard) {
                if (this.stacks[0] == null) {
                    return false;
                }
                return this.oreMatch(this.stacks[0], item);
            }
            for (ItemStack stack : this.stacks) {
                if (stack == null || !StackHelper.isMatchingItem(stack, item, true, false)) continue;
                return true;
            }
            return false;
        }
    }
}

