/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.api.lists.ListRegistry;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class ListHandlerNew {
    public static final int WIDTH = 9;
    public static final int HEIGHT = 2;

    private ListHandlerNew() {
    }

    public static Line[] getLines(ItemStack item) {
        NBTTagCompound data = NBTUtils.getItemData(item);
        if (data.hasKey("written") && data.hasKey("lines")) {
            NBTTagList list = data.getTagList("lines", 10);
            Line[] lines = new Line[list.tagCount()];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = Line.fromNBT(list.getCompoundTagAt(i));
            }
            return lines;
        }
        Line[] lines = new Line[2];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = new Line();
        }
        return lines;
    }

    public static void saveLines(ItemStack stackList, Line[] lines) {
        NBTTagCompound data = NBTUtils.getItemData(stackList);
        data.setBoolean("written", true);
        NBTTagList lineList = new NBTTagList();
        for (Line l : lines) {
            lineList.appendTag((NBTBase)l.toNBT());
        }
        data.setTag("lines", (NBTBase)lineList);
    }

    public static boolean matches(ItemStack stackList, ItemStack item) {
        NBTTagCompound data = NBTUtils.getItemData(stackList);
        if (data.hasKey("written") && data.hasKey("lines")) {
            NBTTagList list = data.getTagList("lines", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                Line line = Line.fromNBT(list.getCompoundTagAt(i));
                if (!line.matches(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Line {
        public final ItemStack[] stacks = new ItemStack[9];
        public boolean precise;
        public boolean byType;
        public boolean byMaterial;

        public boolean isOneStackMode() {
            return this.byType || this.byMaterial;
        }

        public boolean getOption(int id) {
            return id == 0 ? this.precise : (id == 1 ? this.byType : this.byMaterial);
        }

        public void toggleOption(int id) {
            if (!(this.byType || this.byMaterial || id != 1 && id != 2)) {
                for (int i = 1; i < this.stacks.length; ++i) {
                    this.stacks[i] = null;
                }
            }
            switch (id) {
                case 0: {
                    this.precise = !this.precise;
                    break;
                }
                case 1: {
                    this.byType = !this.byType;
                    break;
                }
                case 2: {
                    this.byMaterial = !this.byMaterial;
                }
            }
        }

        public boolean matches(ItemStack target) {
            if (this.byType || this.byMaterial) {
                if (this.stacks[0] == null) {
                    return false;
                }
                List handlers = ListRegistry.getHandlers();
                ListMatchHandler.Type type = this.getSortingType();
                for (ListMatchHandler h : handlers) {
                    if (!h.matches(type, this.stacks[0], target, this.precise)) continue;
                    return true;
                }
            } else {
                for (ItemStack s : this.stacks) {
                    if (s == null || !StackHelper.isMatchingItem(s, target, true, this.precise) || this.precise && s.getItemDamage() != target.getItemDamage()) continue;
                    return true;
                }
            }
            return false;
        }

        public ListMatchHandler.Type getSortingType() {
            return this.byType ? (this.byMaterial ? ListMatchHandler.Type.CLASS : ListMatchHandler.Type.TYPE) : ListMatchHandler.Type.MATERIAL;
        }

        public static Line fromNBT(NBTTagCompound data) {
            Line line = new Line();
            if (data != null && data.hasKey("st")) {
                NBTTagList l = data.getTagList("st", 10);
                for (int i = 0; i < l.tagCount(); ++i) {
                    line.stacks[i] = ItemStack.loadItemStackFromNBT((NBTTagCompound)l.getCompoundTagAt(i));
                }
                line.precise = data.getBoolean("Fp");
                line.byType = data.getBoolean("Ft");
                line.byMaterial = data.getBoolean("Fm");
            }
            return line;
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound data = new NBTTagCompound();
            NBTTagList stackList = new NBTTagList();
            for (ItemStack stack1 : this.stacks) {
                NBTTagCompound stack = new NBTTagCompound();
                if (stack1 != null) {
                    stack1.writeToNBT(stack);
                }
                stackList.appendTag((NBTBase)stack);
            }
            data.setTag("st", (NBTBase)stackList);
            data.setBoolean("Fp", this.precise);
            data.setBoolean("Ft", this.byType);
            data.setBoolean("Fm", this.byMaterial);
            return data;
        }

        public void setStack(int slotIndex, ItemStack stack) {
            if (slotIndex == 0 || !this.byType && !this.byMaterial) {
                if (stack != null && stack.getItem() != null) {
                    this.stacks[slotIndex] = stack.copy();
                    this.stacks[slotIndex].stackSize = 1;
                } else {
                    this.stacks[slotIndex] = null;
                }
            }
        }

        public ItemStack getStack(int i) {
            return i >= 0 && i < this.stacks.length ? this.stacks[i] : null;
        }

        public List<ItemStack> getExamples() {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            if (this.stacks[0] != null) {
                List handlers = ListRegistry.getHandlers();
                ArrayList<ListMatchHandler> handlersCustom = new ArrayList<ListMatchHandler>();
                ListMatchHandler.Type type = this.getSortingType();
                for (ListMatchHandler h : handlers) {
                    if (!h.isValidSource(type, this.stacks[0])) continue;
                    List<ItemStack> examples = h.getClientExamples(type, this.stacks[0]);
                    if (examples != null) {
                        stackList.addAll(examples);
                        continue;
                    }
                    handlersCustom.add(h);
                }
                if (handlersCustom.size() > 0) {
                    for (Object o : Item.itemRegistry) {
                        if (o == null || !(o instanceof Item)) continue;
                        Item i = (Item)o;
                        ArrayList examples = new ArrayList();
                        i.getSubItems(i, CreativeTabs.tabMisc, examples);
                        block2: for (ItemStack s : examples) {
                            for (ListMatchHandler mh : handlersCustom) {
                                if (!mh.matches(type, this.stacks[0], s, false)) continue;
                                stackList.add(s);
                                continue block2;
                            }
                        }
                    }
                }
                Collections.shuffle(stackList);
            }
            return stackList;
        }
    }
}

