/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.BuildCraftCore;
import buildcraft.api.lists.ListMatchHandler;
import buildcraft.core.ItemList;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.buttons.GuiImageButton;
import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.list.ContainerListNew;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiListNew
extends GuiAdvancedInterface
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftcore:textures/gui/list_new.png");
    private static final int BUTTON_COUNT = 3;
    private final Map<Integer, Map<ListMatchHandler.Type, List<ItemStack>>> exampleCache = new HashMap<Integer, Map<ListMatchHandler.Type, List<ItemStack>>>();
    private GuiTextField textField;
    private EntityPlayer player;

    public GuiListNew(EntityPlayer iPlayer) {
        super(new ContainerListNew(iPlayer), (IInventory)iPlayer.inventory, TEXTURE_BASE);
        this.xSize = 176;
        this.ySize = 191;
        this.player = iPlayer;
    }

    private void clearExamplesCache(int lineId) {
        Map<ListMatchHandler.Type, List<ItemStack>> exampleList = this.exampleCache.get(lineId);
        if (exampleList != null) {
            exampleList.clear();
        }
    }

    private List<ItemStack> getExamplesList(int lineId, ListMatchHandler.Type type) {
        Map<ListMatchHandler.Type, List<ItemStack>> exampleList = this.exampleCache.get(lineId);
        if (exampleList == null) {
            exampleList = new EnumMap<ListMatchHandler.Type, List<ItemStack>>(ListMatchHandler.Type.class);
            this.exampleCache.put(lineId, exampleList);
        }
        ContainerListNew container = (ContainerListNew)this.getContainer();
        if (!exampleList.containsKey((Object)type)) {
            List<ItemStack> examples = container.lines[lineId].getExamples();
            ItemStack input = container.lines[lineId].stacks[0];
            if (input != null) {
                ArrayList<ItemStack> repetitions = new ArrayList<ItemStack>();
                for (ItemStack is : examples) {
                    if (!StackHelper.isMatchingItem(input, is, true, false)) continue;
                    repetitions.add(is);
                }
                examples.removeAll(repetitions);
            }
            exampleList.put(type, examples);
        }
        return exampleList.get((Object)type);
    }

    public void initGui() {
        super.initGui();
        this.exampleCache.clear();
        this.slots.clear();
        this.buttonList.clear();
        for (int sy = 0; sy < 2; ++sy) {
            for (int sx = 0; sx < 9; ++sx) {
                this.slots.add(new ListSlot(this, 8 + sx * 18, 32 + sy * 33, sy, sx));
            }
            int bOff = sy * 3;
            int bOffX = this.guiLeft + 8 + 162 - 33;
            int bOffY = this.guiTop + 32 + sy * 33 + 18;
            this.buttonList.add(new GuiImageButton(bOff + 0, bOffX, bOffY, 11, TEXTURE_BASE, 176, 16, 176, 28));
            this.buttonList.add(new GuiImageButton(bOff + 1, bOffX + 11, bOffY, 11, TEXTURE_BASE, 176, 16, 185, 28));
            this.buttonList.add(new GuiImageButton(bOff + 2, bOffX + 22, bOffY, 11, TEXTURE_BASE, 176, 16, 194, 28));
        }
        for (Object o : this.buttonList) {
            GuiImageButton b = (GuiImageButton)o;
            int lineId = b.id / 3;
            int buttonId = b.id % 3;
            if (((ContainerListNew)this.getContainer()).lines[lineId].getOption(buttonId)) {
                b.activate();
            }
            b.registerListener(this);
        }
        this.textField = new GuiTextField(this.fontRendererObj, 10, 10, 156, 12);
        this.textField.setMaxStringLength(32);
        this.textField.setText(BuildCraftCore.listItem.getLabel(this.player.getCurrentEquippedItem()));
        this.textField.setFocused(false);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(f, x, y);
        ContainerListNew containerL = (ContainerListNew)this.getContainer();
        for (int i = 0; i < 2; ++i) {
            if (!containerL.lines[i].isOneStackMode()) continue;
            this.drawTexturedModalRect(this.guiLeft + 6, this.guiTop + 30 + i * 33, 0, this.ySize, 20, 20);
        }
        this.drawBackgroundSlots(x, y);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        this.textField.drawTextBox();
        this.drawTooltipForSlotAt(par1, par2);
    }

    private boolean isCarryingNonEmptyList() {
        ItemStack stack = this.mc.thePlayer.inventory.getItemStack();
        return stack != null && stack.getItem() instanceof ItemList && stack.getTagCompound() != null;
    }

    private boolean hasListEquipped() {
        return this.mc.thePlayer.getCurrentEquippedItem() != null && this.mc.thePlayer.getCurrentEquippedItem().getItem() instanceof ItemList;
    }

    @Override
    protected void mouseClicked(int x, int y, int b) {
        super.mouseClicked(x, y, b);
        if (this.isCarryingNonEmptyList() || !this.hasListEquipped()) {
            return;
        }
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        ContainerListNew container = (ContainerListNew)this.getContainer();
        if (slot instanceof ListSlot) {
            container.setStack(((ListSlot)slot).lineIndex, ((ListSlot)slot).slotIndex, this.mc.thePlayer.inventory.getItemStack());
            this.clearExamplesCache(((ListSlot)slot).lineIndex);
        }
        this.textField.mouseClicked(x - this.guiLeft, y - this.guiTop, b);
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger sender, int id) {
        int buttonId = id % 3;
        int lineId = id / 3;
        ContainerListNew container = (ContainerListNew)this.getContainer();
        container.switchButton(lineId, buttonId);
        this.clearExamplesCache(lineId);
    }

    protected void keyTyped(char c, int i) {
        if (this.textField.isFocused()) {
            if (c == '\r' || c == '\u001b') {
                this.textField.setFocused(false);
            } else {
                this.textField.textboxKeyTyped(c, i);
                ((ContainerListNew)this.container).setLabel(this.textField.getText());
            }
        } else {
            super.keyTyped(c, i);
        }
    }

    private static class ListSlot
    extends AdvancedSlot {
        public int lineIndex;
        public int slotIndex;

        public ListSlot(GuiAdvancedInterface gui, int x, int y, int iLineIndex, int iSlotIndex) {
            super(gui, x, y);
            this.lineIndex = iLineIndex;
            this.slotIndex = iSlotIndex;
        }

        @Override
        public ItemStack getItemStack() {
            ContainerListNew container = (ContainerListNew)this.gui.getContainer();
            if (this.slotIndex == 0 || !container.lines[this.lineIndex].isOneStackMode()) {
                return container.lines[this.lineIndex].getStack(this.slotIndex);
            }
            List data = ((GuiListNew)this.gui).getExamplesList(this.lineIndex, container.lines[this.lineIndex].getSortingType());
            if (data.size() >= this.slotIndex) {
                return (ItemStack)data.get(this.slotIndex - 1);
            }
            return null;
        }

        @Override
        public void drawSprite(int cornerX, int cornerY) {
            if (!this.shouldDrawHighlight()) {
                Minecraft.getMinecraft().renderEngine.bindTexture(TEXTURE_BASE);
                this.gui.drawTexturedModalRect(cornerX + this.x, cornerY + this.y, 176, 0, 16, 16);
            }
            super.drawSprite(cornerX, cornerY);
        }

        @Override
        public boolean shouldDrawHighlight() {
            ContainerListNew container = (ContainerListNew)this.gui.getContainer();
            return this.slotIndex == 0 || !container.lines[this.lineIndex].isOneStackMode();
        }
    }
}

