/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.api.core.BlockIndex;
import buildcraft.core.Box;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BlockScanner
implements Iterable<BlockIndex> {
    Box box = new Box();
    World world;
    int x;
    int y;
    int z;
    int iterationsPerCycle;
    int blocksDone = 0;

    public BlockScanner(Box box, World world, int iterationsPreCycle) {
        this.box = box;
        this.world = world;
        this.iterationsPerCycle = iterationsPreCycle;
        this.x = box.xMin;
        this.y = box.yMin;
        this.z = box.zMin;
    }

    public BlockScanner() {
    }

    @Override
    public Iterator<BlockIndex> iterator() {
        return new BlockIt();
    }

    public int totalBlocks() {
        return this.box.sizeX() * this.box.sizeY() * this.box.sizeZ();
    }

    public int blocksLeft() {
        return this.totalBlocks() - this.blocksDone;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.setInteger("x", this.x);
        nbt.setInteger("y", this.y);
        nbt.setInteger("z", this.z);
        nbt.setInteger("blocksDone", this.blocksDone);
        nbt.setInteger("iterationsPerCycle", this.iterationsPerCycle);
        NBTTagCompound boxNBT = new NBTTagCompound();
        this.box.writeToNBT(boxNBT);
        nbt.setTag("box", (NBTBase)boxNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.x = nbt.getInteger("x");
        this.y = nbt.getInteger("y");
        this.z = nbt.getInteger("z");
        this.blocksDone = nbt.getInteger("blocksDone");
        this.iterationsPerCycle = nbt.getInteger("iterationsPerCycle");
        this.box.initialize(nbt.getCompoundTag("box"));
    }

    class BlockIt
    implements Iterator<BlockIndex> {
        int it = 0;

        BlockIt() {
        }

        @Override
        public boolean hasNext() {
            return BlockScanner.this.z <= BlockScanner.this.box.zMax && this.it <= BlockScanner.this.iterationsPerCycle;
        }

        @Override
        public BlockIndex next() {
            BlockIndex index = new BlockIndex(BlockScanner.this.x, BlockScanner.this.y, BlockScanner.this.z);
            ++this.it;
            ++BlockScanner.this.blocksDone;
            if (BlockScanner.this.x < BlockScanner.this.box.xMax) {
                ++BlockScanner.this.x;
            } else {
                BlockScanner.this.x = BlockScanner.this.box.xMin;
                if (BlockScanner.this.y < BlockScanner.this.box.yMax) {
                    ++BlockScanner.this.y;
                } else {
                    BlockScanner.this.y = BlockScanner.this.box.yMin;
                    ++BlockScanner.this.z;
                }
            }
            return index;
        }

        @Override
        public void remove() {
        }
    }
}

