/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void drawBlockItem(RenderBlocks render, Tessellator tessellator, Block block, IIcon icon) {
        if (icon == null) {
            return;
        }
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        render.renderFaceYNeg(block, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        render.renderFaceYPos(block, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        render.renderFaceZNeg(block, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        render.renderFaceZPos(block, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        render.renderFaceXNeg(block, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        render.renderFaceXPos(block, 0.0, 0.0, 0.0, icon);
        tessellator.draw();
    }

    public static void drawBlockItem(RenderBlocks render, Tessellator tessellator, Block block, int decodedMeta) {
        tessellator.startDrawingQuads();
        IIcon icon = RenderUtils.tryGetBlockIcon(block, 0, decodedMeta);
        if (icon != null) {
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            render.renderFaceYNeg(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 1, decodedMeta)) != null) {
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            render.renderFaceYPos(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 2, decodedMeta)) != null) {
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            render.renderFaceZNeg(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 3, decodedMeta)) != null) {
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            render.renderFaceZPos(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 4, decodedMeta)) != null) {
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            render.renderFaceXNeg(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 5, decodedMeta)) != null) {
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            render.renderFaceXPos(block, 0.0, 0.0, 0.0, icon);
        }
        tessellator.draw();
    }

    public static IIcon tryGetBlockIcon(Block block, int side, int decodedMeta) {
        IIcon icon = null;
        try {
            icon = block.getIcon(side, decodedMeta);
        }
        catch (Throwable t) {
            try {
                icon = block.getBlockTextureFromSide(side);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return icon;
    }
}

