/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import buildcraft.core.lib.EntityBlock;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public final class RenderEntityBlock
extends Render {
    public static RenderEntityBlock INSTANCE = new RenderEntityBlock();
    protected RenderBlocks renderBlocks;

    private RenderEntityBlock() {
        this.renderBlocks = this.field_147909_c;
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doRender(Entity entity, double x, double y, double z, float f, float f1) {
        this.doRenderBlock((EntityBlock)entity, x, y, z);
    }

    public void doRenderBlock(EntityBlock entity, double x, double y, double z) {
        if (entity.isDead) {
            return;
        }
        this.shadowSize = entity.shadowSize;
        RenderInfo util = new RenderInfo();
        util.textureArray = entity.texture;
        this.bindTexture(TextureMap.locationBlocksTexture);
        int iMax = (int)Math.ceil(entity.iSize) - 1;
        int jMax = (int)Math.ceil(entity.jSize) - 1;
        int kMax = (int)Math.ceil(entity.kSize) - 1;
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        for (int iBase = 0; iBase <= iMax; ++iBase) {
            for (int jBase = 0; jBase <= jMax; ++jBase) {
                for (int kBase = 0; kBase <= kMax; ++kBase) {
                    util.renderSide[0] = jBase == 0;
                    util.renderSide[1] = jBase == jMax;
                    util.renderSide[2] = kBase == 0;
                    util.renderSide[3] = kBase == kMax;
                    util.renderSide[4] = iBase == 0;
                    boolean bl = util.renderSide[5] = iBase == iMax;
                    if (!util.renderSide[0] && !util.renderSide[1] && !util.renderSide[2] && !util.renderSide[3] && !util.renderSide[4] && !util.renderSide[5]) continue;
                    util.minX = 0.0;
                    util.minY = 0.0;
                    util.minZ = 0.0;
                    double remainX = entity.iSize - (double)iBase;
                    double remainY = entity.jSize - (double)jBase;
                    double remainZ = entity.kSize - (double)kBase;
                    util.maxX = remainX > 1.0 ? 1.0 : remainX;
                    util.maxY = remainY > 1.0 ? 1.0 : remainY;
                    util.maxZ = remainZ > 1.0 ? 1.0 : remainZ;
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)entity.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)entity.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)entity.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)iBase, (float)jBase, (float)kBase);
                    this.renderBlock(util);
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glTranslatef((float)((float)(-x)), (float)((float)(-y)), (float)((float)(-z)));
    }

    public void renderBlock(RenderInfo info) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        this.renderBlocks.setRenderBounds(info.minX, info.minY, info.minZ, info.maxX, info.maxY, info.maxZ);
        if (info.light != -1) {
            tessellator.setBrightness(info.light << 20 | info.light << 4);
        } else if (info.brightness != -1) {
            tessellator.setBrightness(info.brightness << 4);
        }
        if (info.renderSide[0]) {
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBlocks.renderFaceYNeg(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(0));
        }
        if (info.renderSide[1]) {
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderBlocks.renderFaceYPos(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(1));
        }
        if (info.renderSide[2]) {
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderBlocks.renderFaceZNeg(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(2));
        }
        if (info.renderSide[3]) {
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderBlocks.renderFaceZPos(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(3));
        }
        if (info.renderSide[4]) {
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderBlocks.renderFaceXNeg(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(4));
        }
        if (info.renderSide[5]) {
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderBlocks.renderFaceXPos(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(5));
        }
        tessellator.draw();
    }

    public static class RenderInfo {
        public double minX = 0.0;
        public double minY = 0.0;
        public double minZ = 0.0;
        public double maxX = 1.0;
        public double maxY = 1.0;
        public double maxZ = 1.0;
        public Block baseBlock = Blocks.sand;
        public IIcon texture = null;
        public IIcon[] textureArray = null;
        public boolean[] renderSide = new boolean[]{true, true, true, true, true, true};
        public int light = -1;
        public int brightness = -1;

        public RenderInfo() {
        }

        public RenderInfo(Block template, IIcon[] texture) {
            this();
            this.baseBlock = template;
            this.textureArray = texture;
        }

        public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this();
            this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public void setSkyBlockLight(World world, int x, int y, int z, int light) {
            this.brightness = world.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, x, y, z) << 16 | light;
        }

        public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
            return this.baseBlock.getMixedBrightnessForBlock(iblockaccess, i, j, k);
        }

        public final void setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public final void setRenderSingleSide(int side) {
            Arrays.fill(this.renderSide, false);
            this.renderSide[side] = true;
        }

        public final void setRenderAllSides() {
            Arrays.fill(this.renderSide, true);
        }

        public void rotate() {
            double temp = this.minX;
            this.minX = this.minZ;
            this.minZ = temp;
            temp = this.maxX;
            this.maxX = this.maxZ;
            this.maxZ = temp;
        }

        public void reverseX() {
            double temp = this.minX;
            this.minX = 1.0 - this.maxX;
            this.maxX = 1.0 - temp;
        }

        public void reverseZ() {
            double temp = this.minZ;
            this.minZ = 1.0 - this.maxZ;
            this.maxZ = 1.0 - temp;
        }

        public IIcon getBlockTextureFromSide(int i) {
            if (this.texture != null) {
                return this.texture;
            }
            int index = i;
            if (this.textureArray == null || this.textureArray.length == 0) {
                return this.baseBlock.getBlockTextureFromSide(index);
            }
            if (index >= this.textureArray.length) {
                index = 0;
            }
            return this.textureArray[index];
        }
    }
}

