/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import buildcraft.api.items.IList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    protected StackHelper() {
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.isItemEqual(stack2)) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canStacksOrListsMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.getItem() instanceof IList) {
            IList list = (IList)stack1.getItem();
            return list.matches(stack1, stack2);
        }
        if (stack2.getItem() instanceof IList) {
            IList list = (IList)stack2.getItem();
            return list.matches(stack2, stack1);
        }
        if (!stack1.isItemEqual(stack2)) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public static int mergeStacks(ItemStack mergeSource, ItemStack mergeTarget, boolean doMerge) {
        if (!StackHelper.canStacksMerge(mergeSource, mergeTarget)) {
            return 0;
        }
        int mergeCount = Math.min(mergeTarget.getMaxStackSize() - mergeTarget.stackSize, mergeSource.stackSize);
        if (mergeCount < 1) {
            return 0;
        }
        if (doMerge) {
            mergeTarget.stackSize += mergeCount;
        }
        return mergeCount;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary) {
        int[] idBase;
        if (StackHelper.isMatchingItem(base, comparison, true, false)) {
            return true;
        }
        if (oreDictionary && (idBase = OreDictionary.getOreIDs((ItemStack)base)).length > 0) {
            for (int id : idBase) {
                for (ItemStack itemstack : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (comparison.getItem() != itemstack.getItem() || itemstack.getItemDamage() != Short.MAX_VALUE && comparison.getItemDamage() != itemstack.getItemDamage()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCraftingEquivalent(int[] oreIDs, ItemStack comparison) {
        if (oreIDs.length > 0) {
            for (int id : oreIDs) {
                for (ItemStack itemstack : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (comparison.getItem() != itemstack.getItem() || itemstack.getItemDamage() != Short.MAX_VALUE && comparison.getItemDamage() != itemstack.getItemDamage()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMatchingItemOrList(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() instanceof IList) {
            IList list = (IList)a.getItem();
            return list.matches(a, b);
        }
        if (b.getItem() instanceof IList) {
            IList list = (IList)b.getItem();
            return list.matches(b, a);
        }
        return StackHelper.isMatchingItem(a, b, true, false);
    }

    public static boolean isMatchingItem(ItemStack base, ItemStack comparison) {
        return StackHelper.isMatchingItem(base, comparison, true, true);
    }

    public static boolean isEqualItem(ItemStack a, ItemStack b) {
        if (StackHelper.isMatchingItem(a, b, false, true)) {
            return StackHelper.isWildcard(a) || StackHelper.isWildcard(b) || a.getItemDamage() == b.getItemDamage();
        }
        return false;
    }

    public static boolean isMatchingItem(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (StackHelper.isWildcard(a) || StackHelper.isWildcard(b)) {
            return true;
        }
        if (matchDamage && a.getHasSubtypes() && a.getItemDamage() != b.getItemDamage()) {
            return false;
        }
        return !matchNBT || ItemStack.areItemStackTagsEqual((ItemStack)a, (ItemStack)b);
    }

    public static boolean isWildcard(ItemStack stack) {
        return StackHelper.isWildcard(stack.getItemDamage());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }
}

