/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import buildcraft.api.core.IInvSlot;
import buildcraft.core.lib.inventory.InvUtils;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

class InventoryIteratorSimple
implements Iterable<IInvSlot> {
    private final IInventory inv;

    InventoryIteratorSimple(IInventory inv) {
        this.inv = InvUtils.getInventory(inv);
    }

    @Override
    public Iterator<IInvSlot> iterator() {
        return new Iterator<IInvSlot>(){
            int slot = 0;

            @Override
            public boolean hasNext() {
                return this.slot < InventoryIteratorSimple.this.inv.getSizeInventory();
            }

            @Override
            public IInvSlot next() {
                return new InvSlot(this.slot++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        };
    }

    private class InvSlot
    implements IInvSlot {
        private int slot;

        public InvSlot(int slot) {
            this.slot = slot;
        }

        @Override
        public ItemStack getStackInSlot() {
            return InventoryIteratorSimple.this.inv.getStackInSlot(this.slot);
        }

        @Override
        public void setStackInSlot(ItemStack stack) {
            InventoryIteratorSimple.this.inv.setInventorySlotContents(this.slot, stack);
        }

        @Override
        public boolean canPutStackInSlot(ItemStack stack) {
            return InventoryIteratorSimple.this.inv.isItemValidForSlot(this.slot, stack);
        }

        @Override
        public boolean canTakeStackFromSlot(ItemStack stack) {
            return true;
        }

        @Override
        public boolean isItemValidForSlot(ItemStack stack) {
            return InventoryIteratorSimple.this.inv.isItemValidForSlot(this.slot, stack);
        }

        @Override
        public ItemStack decreaseStackInSlot(int amount) {
            return InventoryIteratorSimple.this.inv.decrStackSize(this.slot, amount);
        }

        @Override
        public int getIndex() {
            return this.slot;
        }
    }
}

