/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public final class InventoryConcatenator
implements IInventory {
    private final List<Integer> slotMap = new ArrayList<Integer>();
    private final List<IInventory> invMap = new ArrayList<IInventory>();

    private InventoryConcatenator() {
    }

    public static InventoryConcatenator make() {
        return new InventoryConcatenator();
    }

    public InventoryConcatenator add(IInventory inv) {
        for (int slot = 0; slot < inv.getSizeInventory(); ++slot) {
            this.slotMap.add(slot);
            this.invMap.add(inv);
        }
        return this;
    }

    public int getSizeInventory() {
        return this.slotMap.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.invMap.get(slot).getStackInSlot(this.slotMap.get(slot).intValue());
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.invMap.get(slot).decrStackSize(this.slotMap.get(slot).intValue(), amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.invMap.get(slot).getStackInSlotOnClosing(this.slotMap.get(slot).intValue());
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.invMap.get(slot).setInventorySlotContents(this.slotMap.get(slot).intValue(), stack);
    }

    public String getInventoryName() {
        return "";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.invMap.get(slot).isItemValidForSlot(this.slotMap.get(slot).intValue(), stack);
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void markDirty() {
        for (IInventory inv : this.invMap) {
            inv.markDirty();
        }
    }
}

