/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.widgets;

import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.widgets.Widget;
import buildcraft.core.lib.render.FluidRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class FluidGaugeWidget
extends Widget {
    public final Tank tank;

    public FluidGaugeWidget(Tank tank, int x, int y, int u, int v, int w, int h) {
        super(x, y, u, v, w, h);
        this.tank = tank;
    }

    @Override
    public ToolTip getToolTip() {
        return this.tank.getToolTip();
    }

    @Override
    public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.tank == null) {
            return;
        }
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null || fluidStack.amount <= 0 || fluidStack.getFluid() == null) {
            return;
        }
        IIcon liquidIcon = FluidRenderer.getFluidTexture(fluidStack, false);
        if (liquidIcon == null) {
            return;
        }
        float scale = (float)Math.min(fluidStack.amount, this.tank.getCapacity()) / (float)this.tank.getCapacity();
        gui.bindTexture(TextureMap.locationBlocksTexture);
        for (int col = 0; col < this.w / 16; ++col) {
            for (int row = 0; row <= this.h / 16; ++row) {
                gui.drawTexturedModelRectFromIcon(guiX + this.x + col * 16, guiY + this.y + row * 16 - 1, liquidIcon, 16, 16);
            }
        }
        gui.bindTexture(gui.texture);
        gui.drawTexturedModalRect(guiX + this.x, guiY + this.y - 1, this.x, this.y - 1, this.w, this.h - (int)Math.floor((float)this.h * scale) + 1);
        gui.drawTexturedModalRect(guiX + this.x, guiY + this.y, this.u, this.v, this.w, this.h);
    }
}

