/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.buttons;

import buildcraft.core.lib.gui.buttons.IMultiButtonState;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public final class MultiButtonController<T extends IMultiButtonState> {
    private int currentState;
    private final T[] validStates;

    private MultiButtonController(int startState, T ... validStates) {
        this.currentState = startState;
        this.validStates = validStates;
    }

    public static <T extends IMultiButtonState> MultiButtonController<T> getController(int startState, T ... validStates) {
        return new MultiButtonController(startState, validStates);
    }

    public MultiButtonController<?> copy() {
        return new MultiButtonController(this.currentState, (IMultiButtonState[])this.validStates.clone());
    }

    public T[] getValidStates() {
        return this.validStates;
    }

    public int incrementState() {
        int newState = this.currentState + 1;
        if (newState >= this.validStates.length) {
            newState = 0;
        }
        this.currentState = newState;
        return this.currentState;
    }

    public void setCurrentState(int state) {
        this.currentState = state;
    }

    public void setCurrentState(T state) {
        for (int i = 0; i < this.validStates.length; ++i) {
            if (this.validStates[i] != state) continue;
            this.currentState = i;
            return;
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public T getButtonState() {
        return this.validStates[this.currentState];
    }

    public void writeToNBT(NBTTagCompound nbt, String tag) {
        nbt.setString(tag, this.getButtonState().name());
    }

    public void readFromNBT(NBTTagCompound nbt, String tag) {
        if (nbt.getTag(tag) instanceof NBTTagString) {
            String name = nbt.getString(tag);
            for (int i = 0; i < this.validStates.length; ++i) {
                if (!this.validStates[i].name().equals(name)) continue;
                this.currentState = i;
                break;
            }
        } else if (nbt.getTag(tag) instanceof NBTTagByte) {
            this.currentState = nbt.getByte(tag);
        }
    }
}

