/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.buttons;

import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.gui.tooltips.IToolTipProvider;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiImageButton
extends GuiButton
implements IButtonClickEventTrigger,
IToolTipProvider {
    private final int size;
    private final int u;
    private final int v;
    private final int baseU;
    private final int baseV;
    private final ResourceLocation texture;
    private ArrayList<IButtonClickEventListener> listeners = new ArrayList();
    private boolean active = false;
    private ToolTip toolTip;

    public GuiImageButton(int id, int x, int y, int size, ResourceLocation texture, int u, int v) {
        this(id, x, y, size, texture, 0, 0, u, v);
    }

    public GuiImageButton(int id, int x, int y, int size, ResourceLocation texture, int baseU, int baseV, int u, int v) {
        super(id, x, y, size, size, "");
        this.size = size;
        this.u = u;
        this.v = v;
        this.baseU = baseU;
        this.baseV = baseV;
        this.texture = texture;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deActivate() {
        this.active = false;
    }

    public void drawButton(Minecraft minecraft, int x, int y) {
        if (!this.visible) {
            return;
        }
        minecraft.renderEngine.bindTexture(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        int buttonState = this.getButtonState(x, y);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, this.baseU + buttonState * this.size, this.baseV, this.size, this.size);
        this.drawTexturedModalRect(this.xPosition + 1, this.yPosition + 1, this.u, this.v, this.size - 2, this.size - 2);
        this.mouseDragged(minecraft, x, y);
    }

    public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
        boolean pressed = super.mousePressed(par1Minecraft, par2, par3);
        if (pressed) {
            this.active = !this.active;
            this.notifyAllListeners();
        }
        return pressed;
    }

    @Override
    public void registerListener(IButtonClickEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IButtonClickEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyAllListeners() {
        for (IButtonClickEventListener listener : this.listeners) {
            listener.handleButtonClick(this, this.id);
        }
    }

    private int getButtonState(int mouseX, int mouseY) {
        if (!this.enabled) {
            return 0;
        }
        if (this.isMouseOverButton(mouseX, mouseY)) {
            if (!this.active) {
                return 2;
            }
            return 4;
        }
        if (!this.active) {
            return 1;
        }
        return 3;
    }

    private boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.size && mouseY < this.yPosition + this.size;
    }

    @Override
    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public GuiImageButton setToolTip(ToolTip tips) {
        this.toolTip = tips;
        return this;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.visible;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOverButton(mouseX, mouseY);
    }
}

