/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.gui.slots.IPhantomSlot;
import buildcraft.core.lib.gui.slots.SlotBase;
import buildcraft.core.lib.gui.widgets.Widget;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.network.PacketGuiWidget;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class BuildCraftContainer
extends Container {
    private List<Widget> widgets = new ArrayList<Widget>();
    private int inventorySize;

    public BuildCraftContainer(int inventorySize) {
        this.inventorySize = inventorySize;
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void addSlot(Slot slot) {
        this.addSlotToContainer(slot);
    }

    public void addWidget(Widget widget) {
        widget.addToContainer(this);
        this.widgets.add(widget);
    }

    public void sendWidgetDataToClient(Widget widget, ICrafting player, byte[] data) {
        PacketGuiWidget pkt = new PacketGuiWidget(this.windowId, this.widgets.indexOf(widget), data);
        BuildCraftCore.instance.sendToPlayer((EntityPlayer)player, pkt);
    }

    public void handleWidgetClientData(int widgetId, ByteBuf data) {
        ByteBufInputStream input = new ByteBufInputStream(data);
        DataInputStream stream = new DataInputStream((InputStream)input);
        try {
            this.widgets.get(widgetId).handleClientPacketData(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addCraftingToCrafters(ICrafting player) {
        super.addCraftingToCrafters(player);
        for (Widget widget : this.widgets) {
            widget.initWidget(player);
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Widget widget : this.widgets) {
            for (ICrafting player : this.crafters) {
                widget.updateWidget(player);
            }
        }
    }

    public ItemStack slotClick(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotNum < 0 ? null : (Slot)this.inventorySlots.get(slotNum);
        if (slot instanceof IPhantomSlot) {
            return this.slotClickPhantom(slot, mouseButton, modifier, player);
        }
        return super.slotClick(slotNum, mouseButton, modifier, player);
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, int modifier, EntityPlayer player) {
        ItemStack stack = null;
        if (mouseButton == 2) {
            if (((IPhantomSlot)slot).canAdjust()) {
                slot.putStack(null);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.inventory;
            slot.onSlotChanged();
            ItemStack stackSlot = slot.getStack();
            ItemStack stackHeld = playerInv.getItemStack();
            if (stackSlot != null) {
                stack = stackSlot.copy();
            }
            if (stackSlot == null) {
                if (stackHeld != null && slot.isItemValid(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            } else if (stackHeld == null) {
                this.adjustPhantomSlot(slot, mouseButton, modifier);
                slot.onPickupFromSlot(player, playerInv.getItemStack());
            } else if (slot.isItemValid(stackHeld)) {
                if (StackHelper.canStacksMerge(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, modifier);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, int modifier) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        ItemStack stackSlot = slot.getStack();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.stackSize + 1) / 2 : stackSlot.stackSize * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.stackSize - 1 : stackSlot.stackSize + 1;
        }
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        stackSlot.stackSize = stackSize;
        if (stackSlot.stackSize <= 0) {
            slot.putStack(null);
        }
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, int modifier) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.stackSize : 1;
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        ItemStack phantomStack = stackHeld.copy();
        phantomStack.stackSize = stackSize;
        slot.putStack(phantomStack);
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.isStackable()) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot == null || !StackHelper.canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.stackSize + stackToShift.stackSize;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                if (resultingStackSize <= max) {
                    stackToShift.stackSize = 0;
                    stackInSlot.stackSize = resultingStackSize;
                    slot.onSlotChanged();
                    changed = true;
                    continue;
                }
                if (stackInSlot.stackSize >= max) continue;
                stackToShift.stackSize -= max - stackInSlot.stackSize;
                stackInSlot.stackSize = max;
                slot.onSlotChanged();
                changed = true;
            }
        }
        if (stackToShift.stackSize > 0) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                stackInSlot = stackToShift.copy();
                stackInSlot.stackSize = Math.min(stackToShift.stackSize, max);
                stackToShift.stackSize -= stackInSlot.stackSize;
                slot.putStack(stackInSlot);
                slot.onSlotChanged();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.inventorySlots.get(machineIndex);
            if (slot instanceof SlotBase && !((SlotBase)slot).canShift() || slot instanceof IPhantomSlot || !slot.isItemValid(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        int numSlots = this.inventorySlots.size();
        if (slot != null && slot.getHasStack()) {
            ItemStack stackInSlot = slot.getStack();
            originalStack = stackInSlot.copy();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.onSlotChange(stackInSlot, originalStack);
            if (stackInSlot.stackSize <= 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (stackInSlot.stackSize == originalStack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(player, stackInSlot);
        }
        return originalStack;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }
}

