/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.fluids;

import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.inventory.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public final class TankUtils {
    private TankUtils() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null || tank == null) {
            return false;
        }
        ItemStack current = player.inventory.getCurrentItem();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.capabilities.isCreativeMode) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, InvUtils.consumeItem(current));
                        player.inventory.markDirty();
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (current.stackSize > 1) {
                    if (!player.inventory.addItemStackToInventory(filled)) {
                        return false;
                    }
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, InvUtils.consumeItem(current));
                    player.inventory.markDirty();
                } else {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, InvUtils.consumeItem(current));
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, filled);
                    player.inventory.markDirty();
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static Block getFluidBlock(Fluid fluid, boolean moving) {
        if (fluid == FluidRegistry.WATER) {
            return moving ? Blocks.flowing_water : Blocks.water;
        }
        if (fluid == FluidRegistry.LAVA) {
            return moving ? Blocks.flowing_lava : Blocks.lava;
        }
        return fluid.getBlock();
    }

    public static void pushFluidToConsumers(IFluidTank tank, int flowCap, TileBuffer[] tileBuffer) {
        int amountToPush = flowCap;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            int used;
            TileEntity tile;
            FluidStack fluidStack = tank.drain(amountToPush, false);
            if (fluidStack == null || fluidStack.amount <= 0 || !((tile = tileBuffer[side.ordinal()].getTile()) instanceof IFluidHandler) || (used = ((IFluidHandler)tile).fill(side.getOpposite(), fluidStack, true)) <= 0) continue;
            tank.drain(used, true);
            if ((amountToPush -= used) > 0) continue;
            return;
        }
    }
}

