/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.fluids;

import buildcraft.core.lib.fluids.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SingleUseTank
extends Tank {
    private Fluid acceptedFluid;

    public SingleUseTank(String name, int capacity, TileEntity tile) {
        super(name, capacity, tile);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (doFill && this.acceptedFluid == null) {
            this.acceptedFluid = resource.getFluid();
        }
        if (this.acceptedFluid == null || this.acceptedFluid == resource.getFluid()) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public void reset() {
        this.acceptedFluid = null;
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = fluid;
    }

    public Fluid getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public void writeTankToNBT(NBTTagCompound nbt) {
        super.writeTankToNBT(nbt);
        if (this.acceptedFluid != null) {
            nbt.setString("acceptedFluid", this.acceptedFluid.getName());
        }
    }

    @Override
    public void readTankFromNBT(NBTTagCompound nbt) {
        super.readTankFromNBT(nbt);
        this.acceptedFluid = FluidRegistry.getFluid((String)nbt.getString("acceptedFluid"));
    }
}

