/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.engines;

import buildcraft.BuildCraftCore;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.render.ICustomHighlight;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockEngineBase
extends BlockBuildCraft
implements ICustomHighlight {
    private static final AxisAlignedBB[][] boxes = new AxisAlignedBB[][]{{AxisAlignedBB.getBoundingBox((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.5)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75, (double)1.0)}, {AxisAlignedBB.getBoundingBox((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.0, (double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.5, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75)}};

    public BlockEngineBase() {
        super(Material.iron);
    }

    public abstract String getTexturePrefix(int var1, boolean var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconAbsolute(int side, int metadata) {
        return this.icons[metadata] == null ? this.icons[0][0] : this.icons[metadata][0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.icons = new IIcon[16][];
        for (int meta = 0; meta < 16; ++meta) {
            String prefix = this.getTexturePrefix(meta, false);
            if (prefix == null) continue;
            this.icons[meta] = new IIcon[1];
            this.icons[meta][0] = register.registerIcon(prefix + "/icon");
        }
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return BuildCraftCore.blockByEntityModel;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngineBase) {
            return ((TileEngineBase)tile).orientation.getOpposite() == side;
        }
        return false;
    }

    @Override
    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngineBase) {
            return ((TileEngineBase)tile).switchOrientation(false);
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer player, int side, float par7, float par8, float par9) {
        TileEntity tile = world.getTileEntity(i, j, k);
        BlockInteractionEvent event = new BlockInteractionEvent(player, (Block)this, world.getBlockMetadata(i, j, k));
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IItemPipe) {
            return false;
        }
        if (tile instanceof TileEngineBase) {
            return ((TileEngineBase)tile).onBlockActivated(player, ForgeDirection.getOrientation((int)side));
        }
        return false;
    }

    public void addCollisionBoxesToList(World wrd, int x, int y, int z, AxisAlignedBB mask, List list, Entity ent) {
        TileEntity tile = wrd.getTileEntity(x, y, z);
        if (tile instanceof TileEngineBase) {
            AxisAlignedBB[] aabbs;
            for (AxisAlignedBB aabb : aabbs = boxes[((TileEngineBase)tile).orientation.ordinal()]) {
                AxisAlignedBB aabbTmp = aabb.getOffsetBoundingBox((double)x, (double)y, (double)z);
                if (!mask.intersectsWith(aabbTmp)) continue;
                list.add(aabbTmp);
            }
        } else {
            super.addCollisionBoxesToList(wrd, x, y, z, mask, list, ent);
        }
    }

    @Override
    public AxisAlignedBB[] getBoxes(World wrd, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = wrd.getTileEntity(x, y, z);
        if (tile instanceof TileEngineBase) {
            return boxes[((TileEngineBase)tile).orientation.ordinal()];
        }
        return new AxisAlignedBB[]{AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
    }

    @Override
    public double getExpansion() {
        return 0.0075;
    }

    public MovingObjectPosition collisionRayTrace(World wrd, int x, int y, int z, Vec3 origin, Vec3 direction) {
        TileEntity tile = wrd.getTileEntity(x, y, z);
        if (tile instanceof TileEngineBase) {
            AxisAlignedBB[] aabbs = boxes[((TileEngineBase)tile).orientation.ordinal()];
            MovingObjectPosition closest = null;
            for (AxisAlignedBB aabb : aabbs) {
                MovingObjectPosition mop = aabb.getOffsetBoundingBox((double)x, (double)y, (double)z).calculateIntercept(origin, direction);
                if (mop == null) continue;
                closest = closest != null && mop.hitVec.distanceTo(origin) < closest.hitVec.distanceTo(origin) ? mop : mop;
            }
            if (closest != null) {
                closest.blockX = x;
                closest.blockY = y;
                closest.blockZ = z;
            }
            return closest;
        }
        return super.collisionRayTrace(wrd, x, y, z, origin, direction);
    }

    public void onPostBlockPlaced(World world, int x, int y, int z, int par5) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngineBase) {
            TileEngineBase engine = (TileEngineBase)tile;
            engine.orientation = ForgeDirection.UP;
            if (!engine.isOrientationValid()) {
                engine.switchOrientation(true);
            }
        }
    }

    public int damageDropped(int i) {
        return i;
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (!(tile instanceof TileEngineBase)) {
            return;
        }
        if (((TileEngineBase)tile).getEnergyStage() == TileEngineBase.EnergyStage.OVERHEAT) {
            for (int f = 0; f < 16; ++f) {
                world.spawnParticle("smoke", (double)((float)i + 0.4f + random.nextFloat() * 0.2f), (double)((float)j + random.nextFloat() * 0.5f), (double)((float)k + 0.4f + random.nextFloat() * 0.2f), (double)(random.nextFloat() * 0.04f - 0.02f), (double)(random.nextFloat() * 0.05f + 0.02f), (double)(random.nextFloat() * 0.04f - 0.02f));
            }
        } else if (((TileEngineBase)tile).isBurning()) {
            float f = (float)i + 0.5f;
            float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)k + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            world.spawnParticle("reddust", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.spawnParticle("reddust", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.spawnParticle("reddust", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            world.spawnParticle("reddust", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngineBase) {
            ((TileEngineBase)tile).onNeighborUpdate();
        }
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return null;
    }

    public abstract String getUnlocalizedName(int var1);

    public abstract TileEntity createTileEntity(World var1, int var2);

    public abstract boolean hasEngine(int var1);
}

