/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.ITileBuilder;
import buildcraft.core.LaserData;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.internal.IBoxProvider;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileAbstractBuilder
extends TileBuildCraft
implements ITileBuilder,
IInventory,
IBoxProvider,
IBuildingItemsProvider,
ICommandReceiver {
    public LinkedList<LaserData> pathLasers = new LinkedList();
    public HashSet<BuildingItem> buildersInAction = new HashSet();
    private int rfPrev = 0;
    private int rfUnchangedCycles = 0;

    public TileAbstractBuilder() {
        this.setBattery(new RFBattery(30720, 1000, 0));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.worldObj.isRemote) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadBuildersInAction", null));
        }
    }

    private Packet createLaunchItemPacket(final BuildingItem i) {
        return new PacketCommand(this, "launchItem", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                i.writeData(data);
            }
        });
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "uploadBuildersInAction".equals(command)) {
            for (BuildingItem i : this.buildersInAction) {
                BuildCraftCore.instance.sendToPlayer((EntityPlayer)sender, this.createLaunchItemPacket(i));
            }
        } else if (side.isClient() && "launchItem".equals(command)) {
            BuildingItem item = new BuildingItem();
            item.readData(stream);
            this.buildersInAction.add(item);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        RFBattery battery = this.getBattery();
        if (this.rfPrev != battery.getEnergyStored()) {
            this.rfPrev = battery.getEnergyStored();
            this.rfUnchangedCycles = 0;
        }
        Iterator<BuildingItem> itemIterator = this.buildersInAction.iterator();
        while (itemIterator.hasNext()) {
            BuildingItem i = itemIterator.next();
            i.update();
            if (!i.isDone()) continue;
            itemIterator.remove();
        }
        if (this.rfPrev != battery.getEnergyStored()) {
            this.rfPrev = battery.getEnergyStored();
            this.rfUnchangedCycles = 0;
        }
        ++this.rfUnchangedCycles;
        if (this.rfUnchangedCycles > 100) {
            battery.useEnergy(0, 1000, false);
            this.rfPrev = battery.getEnergyStored();
        }
    }

    public boolean isWorking() {
        return this.buildersInAction.size() > 0;
    }

    @Override
    public Collection<BuildingItem> getBuilders() {
        return this.buildersInAction;
    }

    public LinkedList<LaserData> getPathLaser() {
        return this.pathLasers;
    }

    @Override
    public void addAndLaunchBuildingItem(BuildingItem item) {
        this.buildersInAction.add(item);
        BuildCraftCore.instance.sendToPlayersNear(this.createLaunchItemPacket(item), this);
    }

    public final int energyAvailable() {
        return this.getBattery().getEnergyStored();
    }

    public final boolean consumeEnergy(int quantity) {
        return this.getBattery().useEnergy(quantity, quantity, false) > 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.rfPrev = this.getBattery().getEnergyStored();
        this.rfUnchangedCycles = 0;
    }

    @Override
    public void readData(ByteBuf stream) {
        int size = stream.readUnsignedShort();
        this.pathLasers.clear();
        for (int i = 0; i < size; ++i) {
            LaserData ld = new LaserData();
            ld.readData(stream);
            this.pathLasers.add(ld);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeShort(this.pathLasers.size());
        for (LaserData ld : this.pathLasers) {
            ld.writeData(stream);
        }
    }

    public double getMaxRenderDistanceSquared() {
        return Double.MAX_VALUE;
    }

    public boolean drainBuild(FluidStack fluidStack, boolean realDrain) {
        return false;
    }

    public Tank[] getFluidTanks() {
        return new Tank[0];
    }
}

