/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.core.builders.BuildingSlotBlock;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BuilderItemMetaPair {
    public Item item;
    public int meta;
    public int position = 0;

    public BuilderItemMetaPair(ItemStack stack) {
        if (stack != null) {
            this.item = stack.getItem();
            this.meta = stack.getItemDamage();
        } else {
            this.item = Item.getItemFromBlock((Block)Blocks.air);
            this.meta = 0;
        }
    }

    public BuilderItemMetaPair(IBuilderContext context, BuildingSlotBlock block) {
        this(BuilderItemMetaPair.findStack(context, block));
    }

    private static ItemStack findStack(IBuilderContext context, BuildingSlotBlock block) {
        LinkedList<ItemStack> s = block.getRequirements(context);
        return s.size() > 0 ? (ItemStack)s.get(0) : null;
    }

    public boolean equals(Object o) {
        if (o instanceof BuilderItemMetaPair) {
            BuilderItemMetaPair imp = (BuilderItemMetaPair)o;
            return imp.item == this.item && imp.meta == this.meta;
        }
        return false;
    }

    public int hashCode() {
        return Item.getIdFromItem((Item)this.item) * 17 + this.meta;
    }
}

