/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.lib.utils.NBTUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class Template
extends BlueprintBase {
    public Template() {
        this.id.extension = "tpl";
    }

    public Template(int sizeX, int sizeY, int sizeZ) {
        super(sizeX, sizeY, sizeZ);
        this.id.extension = "tpl";
    }

    @Override
    public void readFromWorld(IBuilderContext context, TileEntity anchorTile, int x, int y, int z) {
        int posX = (int)((double)x - context.surroundingBox().pMin().x);
        int posY = (int)((double)y - context.surroundingBox().pMin().y);
        int posZ = (int)((double)z - context.surroundingBox().pMin().z);
        if (!BuildCraftAPI.isSoftBlock(anchorTile.getWorldObj(), x, y, z)) {
            this.put(posX, posY, posZ, new SchematicMask(true));
        }
    }

    @Override
    public void saveContents(NBTTagCompound nbt) {
        byte[] data = new byte[this.sizeX * this.sizeY * this.sizeZ];
        int ind = 0;
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    data[ind] = (byte)(this.get(x, y, z) != null ? 1 : 0);
                    ++ind;
                }
            }
        }
        nbt.setByteArray("mask", data);
    }

    @Override
    public void loadContents(NBTTagCompound nbt) throws BptError {
        byte[] data = nbt.getByteArray("mask");
        int ind = 0;
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (data[ind] == 1) {
                        this.put(x, y, z, new SchematicMask(true));
                    }
                    ++ind;
                }
            }
        }
    }

    @Override
    public ItemStack getStack() {
        Item item = (Item)Item.itemRegistry.getObject("BuildCraft|Builders:templateItem");
        ItemStack stack = new ItemStack(item, 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        this.id.write(nbt);
        nbt.setString("author", this.author);
        nbt.setString("name", this.id.name);
        return stack;
    }
}

