/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.ISchematicRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.JavaTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class SchematicRegistry
implements ISchematicRegistry {
    public static SchematicRegistry INSTANCE = new SchematicRegistry();
    private static final HashMap<Class<? extends Schematic>, Constructor<?>> emptyConstructorMap = new HashMap();
    public final HashMap<String, SchematicConstructor> schematicBlocks = new HashMap();
    public final HashMap<Class<? extends Entity>, SchematicConstructor> schematicEntities = new HashMap();
    private final HashSet<String> modsForbidden = new HashSet();
    private final HashSet<String> blocksForbidden = new HashSet();

    private SchematicRegistry() {
    }

    @Override
    public void registerSchematicBlock(Block block, Class<? extends Schematic> clazz, Object ... params) {
        for (int i = 0; i < 16; ++i) {
            this.registerSchematicBlock(block, i, clazz, params);
        }
    }

    @Override
    public void registerSchematicBlock(Block block, int meta, Class<? extends Schematic> clazz, Object ... params) {
        if (block == null || Block.blockRegistry.getNameForObject((Object)block) == null || "null".equals(Block.blockRegistry.getNameForObject((Object)block))) {
            BCLog.logger.warn("Builder: Mod tried to register block '" + (block != null ? block.getClass().getName() : "null") + "' schematic with a null name! Ignoring.");
            return;
        }
        if (this.schematicBlocks.containsKey(this.toStringKey(block, meta))) {
            throw new RuntimeException("Builder: Block " + Block.blockRegistry.getNameForObject((Object)block) + " is already associated with a schematic.");
        }
        this.schematicBlocks.put(this.toStringKey(block, meta), new SchematicConstructor(clazz, params));
    }

    @Override
    public void registerSchematicEntity(Class<? extends Entity> entityClass, Class<? extends SchematicEntity> schematicClass, Object ... params) {
        if (this.schematicEntities.containsKey(entityClass)) {
            throw new RuntimeException("Builder: Entity " + entityClass.getName() + " is already associated with a schematic.");
        }
        this.schematicEntities.put(entityClass, new SchematicConstructor(schematicClass, params));
    }

    public SchematicBlock createSchematicBlock(Block block, int metadata) {
        if (block == null || metadata < 0 || metadata >= 16) {
            return null;
        }
        SchematicConstructor c = this.schematicBlocks.get(this.toStringKey(block, metadata));
        if (c == null) {
            return null;
        }
        try {
            SchematicBlock s = (SchematicBlock)c.newInstance();
            s.block = block;
            return s;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SchematicEntity createSchematicEntity(Class<? extends Entity> entityClass) {
        if (!this.schematicEntities.containsKey(entityClass)) {
            return null;
        }
        try {
            SchematicConstructor c = this.schematicEntities.get(entityClass);
            SchematicEntity s = (SchematicEntity)c.newInstance();
            s.entity = entityClass;
            return s;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isSupported(Block block, int metadata) {
        return this.schematicBlocks.containsKey(this.toStringKey(block, metadata));
    }

    public boolean isAllowedForBuilding(Block block, int metadata) {
        String name = Block.blockRegistry.getNameForObject((Object)block);
        return this.isSupported(block, metadata) && !this.blocksForbidden.contains(name) && !this.modsForbidden.contains(name.split(":", 2)[0]);
    }

    public void readConfiguration(Configuration conf) {
        String strippedId;
        Property excludedMods = conf.get("blueprints", "excludedMods", new String[0], "mods that should be excluded from the builder.").setLanguageKey("config.blueprints.excludedMods").setRequiresMcRestart(true);
        Property excludedBlocks = conf.get("blueprints", "excludedBlocks", new String[0], "blocks that should be excluded from the builder.").setLanguageKey("config.blueprints.excludedBlocks").setRequiresMcRestart(true);
        for (String id : excludedMods.getStringList()) {
            strippedId = JavaTools.stripSurroundingQuotes(id.trim());
            if (strippedId.length() <= 0) continue;
            this.modsForbidden.add(strippedId);
        }
        for (String id : excludedBlocks.getStringList()) {
            strippedId = JavaTools.stripSurroundingQuotes(id.trim());
            if (strippedId.length() <= 0) continue;
            this.blocksForbidden.add(strippedId);
        }
    }

    private String toStringKey(Block block, int meta) {
        return Block.blockRegistry.getNameForObject((Object)block) + ":" + meta;
    }

    public class SchematicConstructor {
        public final Class<? extends Schematic> clazz;
        public final Object[] params;
        private final Constructor<?> constructor;

        SchematicConstructor(Class<? extends Schematic> clazz, Object[] params) throws IllegalArgumentException {
            this.clazz = clazz;
            this.params = params;
            this.constructor = this.findConstructor();
        }

        public Schematic newInstance() throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return (Schematic)this.constructor.newInstance(this.params);
        }

        private Constructor<?> findConstructor() throws IllegalArgumentException {
            if (this.params.length == 0 && emptyConstructorMap.containsKey(this.clazz)) {
                return (Constructor)emptyConstructorMap.get(this.clazz);
            }
            for (Constructor<?> c : this.clazz.getConstructors()) {
                Class<?>[] typesSignature;
                if (c == null || (typesSignature = c.getParameterTypes()).length != this.params.length) continue;
                boolean valid = true;
                for (int i = 0; i < this.params.length; ++i) {
                    Class<?> paramClass;
                    if (this.params[i] == null || typesSignature[i].isAssignableFrom(paramClass = this.params[i].getClass()) || typesSignature[i] == Integer.TYPE && paramClass == Integer.class || typesSignature[i] == Double.TYPE && paramClass == Double.class || typesSignature[i] == Boolean.TYPE && paramClass == Boolean.class) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                if (this.params.length == 0) {
                    emptyConstructorMap.put(this.clazz, c);
                }
                return c;
            }
            throw new IllegalArgumentException("Builder: Could not find matching constructor for class " + this.clazz);
        }
    }
}

