/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.builders.BuilderItemMetaPair;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.fluids.Tank;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldSettings;

public class BuildingSlotMapIterator {
    public static int MAX_PER_ITEM = 512;
    private final BptBuilderBlueprint builderBlueprint;
    private final Map<BuilderItemMetaPair, List<BuildingSlotBlock>> slotMap;
    private final Set<BuilderItemMetaPair> availablePairs = new HashSet<BuilderItemMetaPair>();
    private final int[] buildStageOccurences;
    private final boolean isCreative;
    private Iterator<BuilderItemMetaPair> keyIterator;
    private BuilderItemMetaPair currentKey;
    private List<BuildingSlotBlock> slots;
    private int slotPos;
    private int slotFound;

    public BuildingSlotMapIterator(BptBuilderBlueprint builderBlueprint, TileAbstractBuilder builder) {
        this.builderBlueprint = builderBlueprint;
        this.slotMap = builderBlueprint.buildList;
        this.buildStageOccurences = builderBlueprint.buildStageOccurences;
        this.isCreative = builder == null || builder.getWorldObj().getWorldInfo().getGameType() == WorldSettings.GameType.CREATIVE;
        this.reset();
    }

    public void refresh(TileAbstractBuilder builder) {
        if (!this.isCreative) {
            this.availablePairs.clear();
            this.availablePairs.add(new BuilderItemMetaPair(null));
            if (builder != null) {
                for (int i = 0; i < builder.getSizeInventory(); ++i) {
                    ItemStack stack = builder.getStackInSlot(i);
                    if (stack == null) continue;
                    this.availablePairs.add(new BuilderItemMetaPair(stack));
                }
                for (Tank t : builder.getFluidTanks()) {
                    if (t.getFluid() == null || t.getFluid().getFluid().getBlock() == null) continue;
                    this.availablePairs.add(new BuilderItemMetaPair(new ItemStack(t.getFluid().getFluid().getBlock())));
                }
            }
        }
    }

    public void skipKey() {
        this.findNextKey();
    }

    private void findNextKey() {
        this.slotPos = -1;
        this.slotFound = 0;
        this.slots = null;
        while (this.keyIterator.hasNext()) {
            this.currentKey = this.keyIterator.next();
            if (!this.isCreative && !this.availablePairs.contains(this.currentKey)) continue;
            this.slots = this.slotMap.get(this.currentKey);
            this.slotPos = this.currentKey.position - 1;
            return;
        }
        this.currentKey = null;
        this.keyIterator = this.slotMap.keySet().iterator();
    }

    public BuildingSlotBlock next() {
        if (this.slots == null) {
            this.findNextKey();
        }
        while (this.slots != null) {
            ++this.slotPos;
            while (this.slotFound < MAX_PER_ITEM && this.slotPos < this.slots.size()) {
                BuildingSlotBlock b = this.slots.get(this.slotPos);
                if (b != null) {
                    ++this.slotFound;
                    this.currentKey.position = this.slotPos + 1;
                    return b;
                }
                ++this.slotPos;
            }
            if (this.slotFound >= MAX_PER_ITEM) {
                this.currentKey.position = this.slotPos;
            } else if (this.slotPos >= this.slots.size()) {
                this.currentKey.position = 0;
            }
            this.findNextKey();
        }
        return null;
    }

    public void remove() {
        BuildingSlotBlock slot = this.slots.get(this.slotPos);
        this.slots.set(this.slotPos, null);
        this.builderBlueprint.onRemoveBuildingSlotBlock(slot);
    }

    public void reset() {
        this.keyIterator = this.slotMap.keySet().iterator();
        this.currentKey = null;
        this.slots = null;
        this.findNextKey();
    }
}

