/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IInvSlot;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotIterator;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.utils.BlockUtils;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BptBuilderTemplate
extends BptBuilderBase {
    private LinkedList<BuildingSlotBlock> clearList = new LinkedList();
    private LinkedList<BuildingSlotBlock> buildList = new LinkedList();
    private BuildingSlotIterator iteratorBuild;
    private BuildingSlotIterator iteratorClear;

    public BptBuilderTemplate(BlueprintBase bluePrint, World world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
    }

    @Override
    protected void internalInit() {
        BuildingSlotBlock b;
        SchematicBlockBase slot;
        int zCoord;
        int k;
        int xCoord;
        int i;
        int yCoord;
        int j;
        if (this.blueprint.excavate) {
            for (j = this.blueprint.sizeY - 1; j >= 0; --j) {
                yCoord = j + this.y - this.blueprint.anchorY;
                if (yCoord < 0 || yCoord >= this.context.world.getHeight()) continue;
                for (i = 0; i < this.blueprint.sizeX; ++i) {
                    xCoord = i + this.x - this.blueprint.anchorX;
                    for (k = 0; k < this.blueprint.sizeZ; ++k) {
                        zCoord = k + this.z - this.blueprint.anchorZ;
                        slot = this.blueprint.get(i, j, k);
                        if (slot != null || this.isLocationUsed(xCoord, yCoord, zCoord)) continue;
                        b = new BuildingSlotBlock();
                        b.schematic = null;
                        b.x = xCoord;
                        b.y = yCoord;
                        b.z = zCoord;
                        b.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
                        b.buildStage = 0;
                        this.clearList.add(b);
                    }
                }
            }
        }
        for (j = 0; j < this.blueprint.sizeY; ++j) {
            yCoord = j + this.y - this.blueprint.anchorY;
            if (yCoord < 0 || yCoord >= this.context.world.getHeight()) continue;
            for (i = 0; i < this.blueprint.sizeX; ++i) {
                xCoord = i + this.x - this.blueprint.anchorX;
                for (k = 0; k < this.blueprint.sizeZ; ++k) {
                    zCoord = k + this.z - this.blueprint.anchorZ;
                    slot = this.blueprint.get(i, j, k);
                    if (slot == null || this.isLocationUsed(xCoord, yCoord, zCoord)) continue;
                    b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.Build;
                    b.buildStage = 1;
                    this.buildList.add(b);
                }
            }
        }
        this.iteratorBuild = new BuildingSlotIterator(this.buildList);
        this.iteratorClear = new BuildingSlotIterator(this.clearList);
    }

    private void checkDone() {
        this.done = this.buildList.size() == 0 && this.clearList.size() == 0;
    }

    @Override
    public BuildingSlot reserveNextBlock(World world) {
        return null;
    }

    @Override
    public BuildingSlot getNextBlock(World world, TileAbstractBuilder inv) {
        if (this.buildList.size() != 0 || this.clearList.size() != 0) {
            BuildingSlotBlock slot = this.internalGetNextBlock(world, inv);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
        } else {
            this.checkDone();
        }
        return null;
    }

    private BuildingSlotBlock internalGetNextBlock(World world, TileAbstractBuilder builder) {
        BuildingSlotBlock slot;
        BuildingSlotBlock result = null;
        IInvSlot firstSlotToConsume = null;
        for (IInvSlot invSlot : InventoryIterator.getIterable(builder, ForgeDirection.UNKNOWN)) {
            ItemStack stack;
            if (!builder.isBuildingMaterialSlot(invSlot.getIndex()) || (stack = invSlot.getStackInSlot()) == null || stack.stackSize <= 0) continue;
            firstSlotToConsume = invSlot;
            break;
        }
        this.iteratorClear.startIteration();
        while (this.iteratorClear.hasNext()) {
            slot = this.iteratorClear.next();
            if (slot.buildStage > this.clearList.getFirst().buildStage) {
                this.iteratorClear.reset();
                break;
            }
            if (!world.blockExists(slot.x, slot.y, slot.z) || !this.canDestroy(builder, this.context, slot)) continue;
            if (BlockUtils.isUnbreakableBlock(world, slot.x, slot.y, slot.z) || this.isBlockBreakCanceled(world, slot.x, slot.y, slot.z) || BuildCraftAPI.isSoftBlock(world, slot.x, slot.y, slot.z)) {
                this.iteratorClear.remove();
                this.markLocationUsed(slot.x, slot.y, slot.z);
                continue;
            }
            this.consumeEnergyToDestroy(builder, slot);
            this.createDestroyItems(slot);
            result = slot;
            this.iteratorClear.remove();
            this.markLocationUsed(slot.x, slot.y, slot.z);
            break;
        }
        if (result != null) {
            return result;
        }
        if (firstSlotToConsume == null) {
            return null;
        }
        this.iteratorBuild.startIteration();
        while (this.iteratorBuild.hasNext()) {
            slot = this.iteratorBuild.next();
            if (slot.buildStage > this.buildList.getFirst().buildStage) {
                this.iteratorBuild.reset();
                break;
            }
            if (BlockUtils.isUnbreakableBlock(world, slot.x, slot.y, slot.z) || this.isBlockPlaceCanceled(world, slot.x, slot.y, slot.z, slot.schematic) || !BuildCraftAPI.isSoftBlock(world, slot.x, slot.y, slot.z)) {
                this.iteratorBuild.remove();
                this.markLocationUsed(slot.x, slot.y, slot.z);
                continue;
            }
            if (!builder.consumeEnergy(240)) continue;
            slot.addStackConsumed(firstSlotToConsume.decreaseStackInSlot(1));
            result = slot;
            this.iteratorBuild.remove();
            this.markLocationUsed(slot.x, slot.y, slot.z);
            break;
        }
        return result;
    }
}

