/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.BCLog;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.lib.utils.NBTUtils;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class Blueprint
extends BlueprintBase {
    public LinkedList<SchematicEntity> entities = new LinkedList();

    public Blueprint() {
        this.id.extension = "bpt";
    }

    public Blueprint(int sizeX, int sizeY, int sizeZ) {
        super(sizeX, sizeY, sizeZ);
        this.id.extension = "bpt";
    }

    @Override
    public void rotateLeft(BptContext context) {
        for (SchematicEntity e : this.entities) {
            e.rotateLeft(context);
        }
        super.rotateLeft(context);
    }

    @Override
    public void translateToBlueprint(Translation transform) {
        super.translateToBlueprint(transform);
        for (SchematicEntity e : this.entities) {
            e.translateToBlueprint(transform);
        }
    }

    @Override
    public void translateToWorld(Translation transform) {
        super.translateToWorld(transform);
        for (SchematicEntity e : this.entities) {
            e.translateToWorld(transform);
        }
    }

    @Override
    public void readFromWorld(IBuilderContext context, TileEntity anchorTile, int x, int y, int z) {
        BptContext bptContext = (BptContext)context;
        Block block = anchorTile.getWorldObj().getBlock(x, y, z);
        int meta = anchorTile.getWorldObj().getBlockMetadata(x, y, z);
        if (context.world().isAirBlock(x, y, z)) {
            return;
        }
        SchematicBlock slot = SchematicRegistry.INSTANCE.createSchematicBlock(block, meta);
        if (slot == null) {
            return;
        }
        int posX = (int)((double)x - context.surroundingBox().pMin().x);
        int posY = (int)((double)y - context.surroundingBox().pMin().y);
        int posZ = (int)((double)z - context.surroundingBox().pMin().z);
        slot.block = block;
        slot.meta = meta;
        if (!SchematicRegistry.INSTANCE.isSupported(block, meta)) {
            return;
        }
        try {
            slot.initializeFromObjectAt(context, x, y, z);
            slot.storeRequirements(context, x, y, z);
            this.put(posX, posY, posZ, slot);
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        switch (slot.getBuildingPermission()) {
            case ALL: {
                break;
            }
            case CREATIVE_ONLY: {
                if (bptContext.readConfiguration.allowCreative) {
                    if (this.buildingPermission != BuildingPermission.ALL) break;
                    this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                    break;
                }
                this.put(posX, posY, posZ, null);
                break;
            }
            case NONE: {
                this.buildingPermission = BuildingPermission.NONE;
            }
        }
    }

    @Override
    public void readEntitiesFromWorld(IBuilderContext context, TileEntity anchorTile) {
        BptContext bptContext = (BptContext)context;
        Translation transform = new Translation();
        transform.x = -context.surroundingBox().pMin().x;
        transform.y = -context.surroundingBox().pMin().y;
        transform.z = -context.surroundingBox().pMin().z;
        for (Object o : context.world().loadedEntityList) {
            SchematicEntity s;
            Entity e = (Entity)o;
            if (!context.surroundingBox().contains(e.posX, e.posY, e.posZ) || (s = SchematicRegistry.INSTANCE.createSchematicEntity(e.getClass())) == null) continue;
            s.readFromWorld(context, e);
            switch (s.getBuildingPermission()) {
                case ALL: {
                    this.entities.add(s);
                    break;
                }
                case CREATIVE_ONLY: {
                    if (!bptContext.readConfiguration.allowCreative) break;
                    if (this.buildingPermission == BuildingPermission.ALL) {
                        this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                    }
                    this.entities.add(s);
                    break;
                }
                case NONE: {
                    this.buildingPermission = BuildingPermission.NONE;
                }
            }
        }
    }

    @Override
    public void saveContents(NBTTagCompound nbt) {
        NBTTagList nbtContents = new NBTTagList();
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    SchematicBlockBase schematic = this.get(x, y, z);
                    NBTTagCompound cpt = new NBTTagCompound();
                    if (schematic != null) {
                        schematic.idsToBlueprint(this.mapping);
                        schematic.writeSchematicToNBT(cpt, this.mapping);
                    }
                    nbtContents.appendTag((NBTBase)cpt);
                }
            }
        }
        nbt.setTag("contents", (NBTBase)nbtContents);
        NBTTagList entitiesNBT = new NBTTagList();
        for (SchematicEntity s : this.entities) {
            NBTTagCompound subNBT = new NBTTagCompound();
            s.idsToBlueprint(this.mapping);
            s.writeSchematicToNBT(subNBT, this.mapping);
            entitiesNBT.appendTag((NBTBase)subNBT);
        }
        nbt.setTag("entities", (NBTBase)entitiesNBT);
        NBTTagCompound contextNBT = new NBTTagCompound();
        this.mapping.write(contextNBT);
        nbt.setTag("idMapping", (NBTBase)contextNBT);
    }

    @Override
    public void loadContents(NBTTagCompound nbt) throws BptError {
        this.mapping.read(nbt.getCompoundTag("idMapping"));
        NBTTagList nbtContents = nbt.getTagList("contents", 10);
        int index = 0;
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    NBTTagCompound cpt = nbtContents.getCompoundTagAt(index);
                    ++index;
                    if (cpt.hasKey("blockId")) {
                        Block block;
                        try {
                            block = this.mapping.getBlockForId(cpt.getInteger("blockId"));
                        }
                        catch (MappingNotFoundException e) {
                            block = null;
                            this.isComplete = false;
                        }
                        if (block != null) {
                            int meta = cpt.getInteger("blockMeta");
                            SchematicBlock schematic = SchematicRegistry.INSTANCE.createSchematicBlock(block, meta);
                            if (schematic != null) {
                                ((Schematic)schematic).readSchematicFromNBT(cpt, this.mapping);
                                if (!((Schematic)schematic).doNotUse()) {
                                    schematic.idsToWorld(this.mapping);
                                    switch (((Schematic)schematic).getBuildingPermission()) {
                                        case ALL: {
                                            break;
                                        }
                                        case CREATIVE_ONLY: {
                                            if (this.buildingPermission != BuildingPermission.ALL) break;
                                            this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                                            break;
                                        }
                                        case NONE: {
                                            this.buildingPermission = BuildingPermission.NONE;
                                        }
                                    }
                                } else {
                                    schematic = null;
                                    this.isComplete = false;
                                }
                            }
                            this.put(x, y, z, schematic);
                            continue;
                        }
                        this.put(x, y, z, null);
                        this.isComplete = false;
                        continue;
                    }
                    this.put(x, y, z, null);
                }
            }
        }
        NBTTagList entitiesNBT = nbt.getTagList("entities", 10);
        for (int i = 0; i < entitiesNBT.tagCount(); ++i) {
            Class<? extends Entity> entity;
            NBTTagCompound cpt = entitiesNBT.getCompoundTagAt(i);
            if (!cpt.hasKey("entityId")) continue;
            try {
                entity = this.mapping.getEntityForId(cpt.getInteger("entityId"));
            }
            catch (MappingNotFoundException e) {
                entity = null;
                this.isComplete = false;
            }
            if (entity != null) {
                SchematicEntity s = SchematicRegistry.INSTANCE.createSchematicEntity(entity);
                s.readSchematicFromNBT(cpt, this.mapping);
                s.idsToWorld(this.mapping);
                this.entities.add(s);
                continue;
            }
            this.isComplete = false;
        }
    }

    @Override
    public ItemStack getStack() {
        Item item = (Item)Item.itemRegistry.getObject("BuildCraft|Builders:blueprintItem");
        ItemStack stack = new ItemStack(item, 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        this.id.write(nbt);
        nbt.setString("author", this.author);
        nbt.setString("name", this.id.name);
        nbt.setByte("permission", (byte)this.buildingPermission.ordinal());
        nbt.setBoolean("isComplete", this.isComplete);
        return stack;
    }
}

