/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.items.IList;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.list.ListHandlerNew;
import buildcraft.core.list.ListHandlerOld;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemList
extends ItemBuildCraft
implements IList {
    public ItemList() {
        this.setHasSubtypes(true);
        this.setMaxStackSize(1);
    }

    public IIcon getIconIndex(ItemStack stack) {
        this.itemIcon = this.icons[NBTUtils.getItemData(stack).hasKey("written") ? 1 : 0];
        return this.itemIcon;
    }

    @Override
    public String[] getIconNames() {
        return new String[]{"list/clean", "list/used"};
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            player.openGui((Object)BuildCraftCore.instance, stack.getItemDamage() == 1 ? 19 : 17, world, 0, 0, 0);
        }
        return stack;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        NBTTagCompound nbt;
        if (stack.getItemDamage() == 0) {
            list.add(EnumChatFormatting.DARK_RED + StatCollector.translateToLocal((String)"tip.deprecated"));
        }
        if ((nbt = NBTUtils.getItemData(stack)).hasKey("label")) {
            list.add(nbt.getString("label"));
        }
    }

    public static void saveLabel(ItemStack stack, String text) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        nbt.setString("label", text);
    }

    @Override
    public boolean setName(ItemStack stack, String name) {
        ItemList.saveLabel(stack, name);
        return true;
    }

    @Override
    public String getName(ItemStack stack) {
        return this.getLabel(stack);
    }

    @Override
    public String getLabel(ItemStack stack) {
        return NBTUtils.getItemData(stack).getString("label");
    }

    @Override
    public boolean matches(ItemStack stackList, ItemStack item) {
        if (stackList.getItemDamage() == 1) {
            return ListHandlerNew.matches(stackList, item);
        }
        return ListHandlerOld.matches(stackList, item);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack((Item)this, 1, 0));
        itemList.add(new ItemStack((Item)this, 1, 1));
    }
}

