/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftCore;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.gui.ContainerBuilder;
import buildcraft.builders.gui.SlotBuilderRequirement;
import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiBuilder
extends GuiAdvancedInterface {
    private static final ResourceLocation REGULAR_TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/builder.png");
    private static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/builder_blueprint.png");
    private TileBuilder builder;
    private GuiButton selectedButton;

    public GuiBuilder(IInventory playerInventory, TileBuilder builder) {
        super(new ContainerBuilder(playerInventory, builder), builder, BLUEPRINT_TEXTURE);
        this.builder = builder;
        this.xSize = 256;
        this.ySize = 225;
        this.resetNullSlots(24);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots.set(i * 4 + j, new SlotBuilderRequirement(this, 179 + j * 18, 18 + i * 18));
            }
        }
    }

    private ContainerBuilder getContainerBuilder() {
        return (ContainerBuilder)this.getContainer();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        this.drawCenteredString(StringUtils.localize("tile.builderBlock.name"), 89, 16, 0x404040);
        if (this.builder.getStackInSlot(0) != null) {
            this.fontRendererObj.drawString(StringUtils.localize("gui.building.resources"), 8, 60, 0x404040);
            this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 97, 0x404040);
            this.fontRendererObj.drawString(StringUtils.localize("gui.needed"), 178, 7, 0x404040);
            this.fontRendererObj.drawString(StringUtils.localize("gui.building.fluids"), 178, 133, 0x404040);
        }
        this.drawTooltips(par1, par2);
    }

    private void drawTooltips(int par1, int par2) {
        int top = this.guiTop + 145;
        for (int i = 0; i < this.builder.fluidTanks.length; ++i) {
            int left = this.guiLeft + 179 + 18 * i;
            if (par1 < left || par2 < top || par1 >= left + 16 || par2 >= left + 47) continue;
            ArrayList<String> fluidTip = new ArrayList<String>();
            Tank tank = this.builder.fluidTanks[i];
            if (tank.getFluid() != null && tank.getFluid().amount > 0) {
                fluidTip.add(tank.getFluid().getLocalizedName());
                if (!BuildCraftCore.hideFluidNumbers) {
                    fluidTip.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + tank.getFluid().amount + " mB");
                }
            } else {
                fluidTip.add(StatCollector.translateToLocal((String)"gui.fluidtank.empty"));
            }
            this.drawHoveringText(fluidTip, par1 - this.guiLeft, par2 - this.guiTop, this.fontRendererObj);
            return;
        }
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        List<RequirementItemStack> needs;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean isBlueprint = this.builder.getStackInSlot(0) != null;
        this.mc.renderEngine.bindTexture(REGULAR_TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, 176, this.ySize);
        this.mc.renderEngine.bindTexture(BLUEPRINT_TEXTURE);
        if (isBlueprint) {
            this.drawTexturedModalRect(this.guiLeft + 169, this.guiTop, 169, 0, 87, this.ySize);
        }
        if ((needs = this.builder.getNeededItems()) != null) {
            if (needs.size() > this.slots.size()) {
                this.getContainerBuilder().scrollbarWidget.hidden = false;
                this.getContainerBuilder().scrollbarWidget.setLength((needs.size() - this.slots.size() + 3) / 4);
            } else {
                this.getContainerBuilder().scrollbarWidget.hidden = true;
            }
            int offset = this.getContainerBuilder().scrollbarWidget.getPosition() * 4;
            for (int s = 0; s < this.slots.size(); ++s) {
                int ts = offset + s;
                ((SlotBuilderRequirement)this.slots.get((int)s)).stack = ts >= needs.size() ? null : needs.get(ts);
            }
            for (GuiButton b : this.buttonList) {
                b.visible = true;
            }
        } else {
            this.getContainerBuilder().scrollbarWidget.hidden = true;
            for (AdvancedSlot slot : this.slots) {
                ((SlotBuilderRequirement)slot).stack = null;
            }
            for (GuiButton b : this.buttonList) {
                b.visible = false;
            }
        }
        this.drawWidgets(x, y);
        if (isBlueprint) {
            this.drawBackgroundSlots(x, y);
        }
        if (isBlueprint) {
            Tank tank;
            int i;
            for (i = 0; i < this.builder.fluidTanks.length; ++i) {
                tank = this.builder.fluidTanks[i];
                if (tank.getFluid() == null || tank.getFluid().amount <= 0) continue;
                this.drawFluid(tank.getFluid(), this.guiLeft + 179 + 18 * i, this.guiTop + 145, 16, 47, tank.getCapacity());
            }
            this.mc.renderEngine.bindTexture(BLUEPRINT_TEXTURE);
            for (i = 0; i < this.builder.fluidTanks.length; ++i) {
                tank = this.builder.fluidTanks[i];
                if (tank.getFluid() == null || tank.getFluid().amount <= 0) continue;
                this.drawTexturedModalRect(this.guiLeft + 179 + 18 * i, this.guiTop + 145, 0, 54, 16, 47);
            }
        }
    }

    public void initGui() {
        super.initGui();
        for (int i = 0; i < 4; ++i) {
            this.buttonList.add(new BuilderEraseButton(i, this.guiLeft + 178 + 18 * i, this.guiTop + 197, 18, 18));
        }
    }

    @Override
    protected void mouseMovedOrUp(int mouseX, int mouseY, int eventType) {
        super.mouseMovedOrUp(mouseX, mouseY, eventType);
        if (this.selectedButton != null && eventType == 0) {
            this.selectedButton.mouseReleased(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    private class BuilderEraseButton
    extends GuiButton {
        private boolean clicked;

        public BuilderEraseButton(int id, int x, int y, int width, int height) {
            super(id, x, y, width, height, null);
        }

        public boolean mousePressed(Minecraft mc, int x, int y) {
            if (super.mousePressed(mc, x, y)) {
                GuiBuilder.this.selectedButton = this;
                this.clicked = true;
                BuildCraftCore.instance.sendToServer(new PacketCommand(GuiBuilder.this.builder, "eraseFluidTank", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        data.writeInt(BuilderEraseButton.this.id);
                    }
                }));
                return true;
            }
            return false;
        }

        public void mouseReleased(int x, int y) {
            super.mouseReleased(x, y);
            this.clicked = false;
        }

        public void drawButton(Minecraft mc, int x, int y) {
            if (!this.visible) {
                return;
            }
            this.field_146123_n = x >= this.xPosition && y >= this.yPosition && x < this.xPosition + this.width && y < this.yPosition + this.height;
            mc.renderEngine.bindTexture(BLUEPRINT_TEXTURE);
            this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, (this.clicked ? 1 : (this.field_146123_n ? 2 : 0)) * 18, 18, 18);
            this.mouseDragged(mc, x, y);
        }
    }
}

