/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.builders.patterns.PatternFill;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileFiller
extends TileAbstractBuilder
implements IHasWork,
IControllable,
ICommandReceiver,
IStatementContainer,
ILEDProvider {
    private static int POWER_ACTIVATION = 500;
    public FillerPattern currentPattern = PatternFill.INSTANCE;
    public IStatementParameter[] patternParameters;
    private BptBuilderTemplate currentTemplate;
    private final Box box = new Box();
    private boolean done = false;
    private boolean excavate = true;
    private SimpleInventory inv = new SimpleInventory(27, "Filler", 64);
    private NBTTagCompound initNBT = null;

    public TileFiller() {
        this.inv.addListener(this);
        this.box.kind = Box.Kind.STRIPES;
    }

    public boolean isExcavate() {
        return this.excavate;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.worldObj.isRemote) {
            return;
        }
        IAreaProvider a = Utils.getNearbyAreaProvider(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (a != null) {
            this.box.initialize(a);
            a.removeFromWorld();
            this.sendNetworkUpdate();
        }
        if (this.currentTemplate == null) {
            this.initTemplate();
        }
        if (this.initNBT != null && this.currentTemplate != null) {
            this.currentTemplate.loadBuildStateToNBT(this.initNBT.getCompoundTag("builderState"), this);
        }
        this.initNBT = null;
    }

    private void initTemplate() {
        if (this.currentPattern != null && this.box.isInitialized() && this.box.sizeX() > 0 && this.box.sizeY() > 0 && this.box.sizeZ() > 0) {
            this.currentTemplate = this.currentPattern.getTemplateBuilder(this.box, this.getWorldObj(), this.patternParameters);
            this.currentTemplate.blueprint.excavate = this.excavate;
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.mode == IControllable.Mode.Off) {
            return;
        }
        if (!this.box.isInitialized()) {
            return;
        }
        if (this.getBattery().getEnergyStored() < POWER_ACTIVATION) {
            return;
        }
        boolean oldDone = this.done;
        if (this.done) {
            if (this.mode == IControllable.Mode.Loop) {
                this.done = false;
            } else {
                return;
            }
        }
        if (this.currentTemplate == null) {
            this.initTemplate();
        }
        if (this.currentTemplate != null) {
            this.currentTemplate.buildNextSlot(this.worldObj, this, this.xCoord, this.yCoord, this.zCoord);
            if (this.currentTemplate.isDone(this)) {
                this.done = true;
                this.currentTemplate = null;
            }
        }
        if (oldDone != this.done) {
            this.sendNetworkUpdate();
        }
    }

    public final int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(slot, amount);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(slot, stack);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public String getInventoryName() {
        return "Filler";
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.inv.readFromNBT(nbt);
        if (nbt.hasKey("pattern")) {
            this.currentPattern = (FillerPattern)FillerManager.registry.getPattern(nbt.getString("pattern"));
        }
        if (this.currentPattern == null) {
            this.currentPattern = PatternFill.INSTANCE;
        }
        if (nbt.hasKey("pp")) {
            this.readParametersFromNBT(nbt.getCompoundTag("pp"));
        } else {
            this.initPatternParameters();
        }
        if (nbt.hasKey("box")) {
            this.box.initialize(nbt.getCompoundTag("box"));
        }
        this.done = nbt.getBoolean("done");
        this.excavate = nbt.hasKey("excavate") ? nbt.getBoolean("excavate") : true;
        this.initNBT = (NBTTagCompound)nbt.getCompoundTag("bpt").copy();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.inv.writeToNBT(nbt);
        if (this.currentPattern != null) {
            nbt.setString("pattern", this.currentPattern.getUniqueTag());
        }
        NBTTagCompound boxStore = new NBTTagCompound();
        this.box.writeToNBT(boxStore);
        nbt.setTag("box", (NBTBase)boxStore);
        nbt.setBoolean("done", this.done);
        nbt.setBoolean("excavate", this.excavate);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.currentTemplate != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.currentTemplate.saveBuildStateToNBT(builderCpt, this);
            bptNBT.setTag("builderState", (NBTBase)builderCpt);
        }
        nbt.setTag("bpt", (NBTBase)bptNBT);
        NBTTagCompound ppNBT = new NBTTagCompound();
        this.writeParametersToNBT(ppNBT);
        nbt.setTag("pp", (NBTBase)ppNBT);
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.destroy();
    }

    private void initPatternParameters() {
        this.patternParameters = new IStatementParameter[this.currentPattern.maxParameters()];
        for (int i = 0; i < this.currentPattern.minParameters(); ++i) {
            this.patternParameters[i] = this.currentPattern.createParameter(i);
        }
    }

    public void setPattern(FillerPattern pattern) {
        if (pattern != null && this.currentPattern != pattern) {
            this.currentPattern = pattern;
            this.currentTemplate = null;
            this.done = false;
            this.initPatternParameters();
            this.sendNetworkUpdate();
        }
    }

    private void writeParametersToNBT(NBTTagCompound nbt) {
        nbt.setByte("length", (byte)(this.patternParameters != null ? this.patternParameters.length : 0));
        if (this.patternParameters != null) {
            for (int i = 0; i < this.patternParameters.length; ++i) {
                if (this.patternParameters[i] == null) continue;
                NBTTagCompound patternData = new NBTTagCompound();
                patternData.setString("kind", this.patternParameters[i].getUniqueTag());
                this.patternParameters[i].writeToNBT(patternData);
                nbt.setTag("p" + i, (NBTBase)patternData);
            }
        }
    }

    private void readParametersFromNBT(NBTTagCompound nbt) {
        this.patternParameters = new IStatementParameter[nbt.getByte("length")];
        for (int i = 0; i < this.patternParameters.length; ++i) {
            if (!nbt.hasKey("p" + i)) continue;
            NBTTagCompound patternData = nbt.getCompoundTag("p" + i);
            this.patternParameters[i] = StatementManager.createParameter(patternData.getString("kind"));
            this.patternParameters[i].readFromNBT(patternData);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        this.box.writeData(data);
        data.writeByte((this.done ? 1 : 0) | (this.excavate ? 2 : 0));
        NetworkUtils.writeUTF(data, this.currentPattern.getUniqueTag());
        NBTTagCompound parameterData = new NBTTagCompound();
        this.writeParametersToNBT(parameterData);
        NetworkUtils.writeNBT(data, parameterData);
    }

    @Override
    public void readData(ByteBuf data) {
        this.box.readData(data);
        short flags = data.readUnsignedByte();
        this.done = (flags & 1) > 0;
        this.excavate = (flags & 2) > 0;
        FillerPattern pattern = (FillerPattern)FillerManager.registry.getPattern(NetworkUtils.readUTF(data));
        NBTTagCompound parameterData = NetworkUtils.readNBT(data);
        this.readParametersFromNBT(parameterData);
        this.setPattern(pattern);
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public boolean hasWork() {
        return !this.done && this.mode != IControllable.Mode.Off;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    public void rpcSetPatternFromString(final String name) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setPattern", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeUTF(data, name);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        super.receiveCommand(command, side, sender, stream);
        if (side.isServer()) {
            if ("setPattern".equals(command)) {
                String name = NetworkUtils.readUTF(stream);
                this.setPattern((FillerPattern)FillerManager.registry.getPattern(name));
                this.done = false;
            } else if ("setParameters".equals(command)) {
                NBTTagCompound patternData = NetworkUtils.readNBT(stream);
                this.readParametersFromNBT(patternData);
                this.currentTemplate = null;
                this.done = false;
            } else if ("setFlags".equals(command)) {
                this.excavate = stream.readBoolean();
                this.currentTemplate = null;
                this.sendNetworkUpdate();
                this.done = false;
            }
        }
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.box).expand(50).getBoundingBox();
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return true;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off || mode == IControllable.Mode.Loop;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public void rpcSetParameter(int i, IStatementParameter patternParameter) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setParameters", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NBTTagCompound parameterData = new NBTTagCompound();
                TileFiller.this.writeParametersToNBT(parameterData);
                NetworkUtils.writeNBT(data, parameterData);
            }
        }));
    }

    @Override
    public int getLEDLevel(int led) {
        return (led == 0 ? this.done : this.buildersInAction.size() > 0) ? 15 : 0;
    }

    public void setExcavate(boolean excavate) {
        this.excavate = excavate;
    }
}

