/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.api.library.LibraryAPI;
import buildcraft.api.library.LibraryTypeHandler;
import buildcraft.api.library.LibraryTypeHandlerByteArray;
import buildcraft.api.library.LibraryTypeHandlerNBT;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class TileBlueprintLibrary
extends TileBuildCraft
implements IInventory,
ICommandReceiver {
    private static final int PROGRESS_TIME = 100;
    private static final int CHUNK_SIZE = 16384;
    public SimpleInventory inv = new SimpleInventory(4, "Electronic Library", 1);
    public int progressIn = 0;
    public int progressOut = 0;
    public List<LibraryId> entries;
    public int selected = -1;
    public EntityPlayer uploadingPlayer = null;
    public EntityPlayer downloadingPlayer = null;
    private LibraryId blueprintDownloadId;
    private byte[] blueprintDownload;

    public void refresh() {
        if (this.worldObj.isRemote) {
            BuildCraftBuilders.clientDB.refresh();
            this.entries = BuildCraftBuilders.clientDB.getBlueprintIds();
            this.selected = -1;
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.refresh();
    }

    public void deleteSelectedBpt() {
        if (this.selected != -1) {
            BuildCraftBuilders.clientDB.deleteBlueprint(this.entries.get(this.selected));
            this.entries = BuildCraftBuilders.clientDB.getBlueprintIds();
            if (this.selected >= this.entries.size()) {
                --this.selected;
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
    }

    public int getSizeInventory() {
        return 4;
    }

    public ItemStack getStackInSlot(int i) {
        return this.inv.getStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        ItemStack result = this.inv.decrStackSize(i, j);
        if (i == 0 && this.getStackInSlot(0) == null) {
            this.progressIn = 0;
        }
        if (i == 2 && this.getStackInSlot(2) == null) {
            this.progressOut = 0;
        }
        return result;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.inv.setInventorySlotContents(i, itemstack);
        if (i == 0) {
            this.progressIn = this.getStackInSlot(0) != null && this.findHandler(0, LibraryTypeHandler.HandlerType.STORE) != null ? 1 : 0;
        }
        if (i == 2) {
            this.progressOut = this.getStackInSlot(2) != null && this.findHandler(2, LibraryTypeHandler.HandlerType.LOAD) != null ? 1 : 0;
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public String getInventoryName() {
        return "";
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    private LibraryTypeHandler findHandler(int slot, LibraryTypeHandler.HandlerType type) {
        if (!this.worldObj.isRemote) {
            ItemStack stack = this.getStackInSlot(slot);
            for (LibraryTypeHandler h : LibraryAPI.getHandlerSet()) {
                if (!h.isHandler(stack, type)) continue;
                return h;
            }
        }
        return null;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.progressIn > 0 && this.progressIn < 100) {
            ++this.progressIn;
        }
        if (this.progressOut > 0 && this.progressOut < 100) {
            this.progressOut = this.selected != -1 ? ++this.progressOut : 1;
        }
        if (this.progressIn == 100 && this.getStackInSlot(1) == null) {
            LibraryTypeHandler handler = this.findHandler(0, LibraryTypeHandler.HandlerType.STORE);
            if (handler == null) {
                this.uploadingPlayer = null;
                return;
            }
            byte[] data = null;
            if (handler instanceof LibraryTypeHandlerNBT) {
                NBTTagCompound nbt = new NBTTagCompound();
                if (((LibraryTypeHandlerNBT)handler).store(this.getStackInSlot(0), nbt)) {
                    data = NBTUtils.save(nbt);
                }
            } else if (handler instanceof LibraryTypeHandlerByteArray) {
                data = ((LibraryTypeHandlerByteArray)handler).store(this.getStackInSlot(0));
            }
            if (data == null) {
                this.uploadingPlayer = null;
                return;
            }
            this.setInventorySlotContents(1, this.getStackInSlot(0));
            this.setInventorySlotContents(0, null);
            final byte[] dataOut = data;
            final LibraryId id = new LibraryId();
            id.name = handler.getName(this.getStackInSlot(1));
            id.extension = handler.getOutputExtension();
            if (this.uploadingPlayer != null) {
                BuildCraftCore.instance.sendToPlayer(this.uploadingPlayer, new PacketCommand(this, "downloadBlueprintToClient", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        id.generateUniqueId(dataOut);
                        id.writeData(data);
                        NetworkUtils.writeByteArray(data, dataOut);
                    }
                }));
                this.uploadingPlayer = null;
            }
        }
        if (this.progressOut == 100 && this.getStackInSlot(3) == null) {
            BuildCraftCore.instance.sendToPlayer(this.downloadingPlayer, new PacketCommand(this, "requestSelectedBlueprint", null));
            this.progressOut = 0;
        }
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("requestSelectedBlueprint".equals(command)) {
                if (this.isOutputConsistent()) {
                    if (this.selected > -1 && this.selected < this.entries.size()) {
                        NBTTagCompound compound = BuildCraftBuilders.clientDB.load(this.entries.get(this.selected));
                        compound.setString("__filename", this.entries.get((int)this.selected).name);
                        final byte[] bptData = NBTUtils.save(compound);
                        final int chunks = (bptData.length + 16384 - 1) / 16384;
                        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadServerBegin", new CommandWriter(){

                            @Override
                            public void write(ByteBuf data) {
                                TileBlueprintLibrary.this.entries.get(TileBlueprintLibrary.this.selected).writeData(data);
                                data.writeShort(chunks);
                            }
                        }));
                        int i = 0;
                        while (i < chunks) {
                            final int chunk = i++;
                            final int start = 16384 * chunk;
                            final int length = Math.min(16384, bptData.length - start);
                            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadServerChunk", new CommandWriter(){

                                @Override
                                public void write(ByteBuf data) {
                                    data.writeShort(chunk);
                                    data.writeShort(length);
                                    data.writeBytes(bptData, start, length);
                                }
                            }));
                        }
                        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadServerEnd", null));
                    } else {
                        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadNothingToServer", null));
                    }
                }
            } else if ("downloadBlueprintToClient".equals(command)) {
                LibraryId id = new LibraryId();
                id.readData(stream);
                byte[] data = NetworkUtils.readByteArray(stream);
                try {
                    LibraryTypeHandler handler = LibraryAPI.getHandlerFor(id.extension);
                    if (handler == null) {
                        return;
                    }
                    NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    BuildCraftBuilders.clientDB.add(id, nbt);
                    this.entries = BuildCraftBuilders.clientDB.getBlueprintIds();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (side.isServer()) {
            if ("uploadNothingToServer".equals(command)) {
                this.setInventorySlotContents(3, this.getStackInSlot(2));
                this.setInventorySlotContents(2, null);
                this.downloadingPlayer = null;
            } else if ("uploadServerBegin".equals(command)) {
                this.blueprintDownloadId = new LibraryId();
                this.blueprintDownloadId.readData(stream);
                this.blueprintDownload = new byte[16384 * stream.readUnsignedShort()];
            } else if ("uploadServerChunk".equals(command)) {
                int start = stream.readUnsignedShort() * 16384;
                int length = stream.readUnsignedShort();
                if (this.blueprintDownload != null) {
                    stream.readBytes(this.blueprintDownload, start, length);
                } else {
                    stream.skipBytes(length);
                }
            } else if ("uploadServerEnd".equals(command)) {
                try {
                    LibraryTypeHandler handler = LibraryAPI.getHandlerFor(this.blueprintDownloadId.extension);
                    if (handler != null) {
                        ItemStack output = null;
                        if (handler instanceof LibraryTypeHandlerNBT) {
                            NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])this.blueprintDownload, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                            output = ((LibraryTypeHandlerNBT)handler).load(this.getStackInSlot(2), nbt);
                        } else if (handler instanceof LibraryTypeHandlerByteArray) {
                            output = ((LibraryTypeHandlerByteArray)handler).load(this.getStackInSlot(2), this.blueprintDownload);
                        }
                        if (output != null) {
                            this.setInventorySlotContents(3, output);
                            this.setInventorySlotContents(2, null);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.blueprintDownloadId = null;
                this.blueprintDownload = null;
                this.downloadingPlayer = null;
            } else if ("selectBlueprint".equals(command)) {
                this.selected = stream.readInt();
            }
        }
    }

    public void selectBlueprint(int index) {
        this.selected = index;
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "selectBlueprint", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeInt(TileBlueprintLibrary.this.selected);
            }
        }));
    }

    private boolean isOutputConsistent() {
        if (this.selected <= -1 || this.selected >= this.entries.size() || this.getStackInSlot(2) == null) {
            return false;
        }
        return LibraryAPI.getHandlerFor(this.entries.get((int)this.selected).extension).isHandler(this.getStackInSlot(2), LibraryTypeHandler.HandlerType.LOAD);
    }
}

