/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.builders.blueprints.RecursiveBlueprintReader;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.internal.IBoxProvider;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileArchitect
extends TileBuildCraft
implements IInventory,
IBoxProvider,
ICommandReceiver,
ILEDProvider {
    public String currentAuthorName = "";
    public Mode mode = Mode.NONE;
    public Box box = new Box();
    public String name = "";
    public BlueprintReadConfiguration readConfiguration = new BlueprintReadConfiguration();
    public ArrayList<LaserData> subLasers = new ArrayList();
    public ArrayList<BlockIndex> subBlueprints = new ArrayList();
    private SimpleInventory inv = new SimpleInventory(2, "Architect", 1);
    private RecursiveBlueprintReader reader;
    private boolean clientIsWorking;
    private boolean initialized;

    public TileArchitect() {
        this.box.kind = Box.Kind.BLUE_STRIPES;
    }

    public void storeBlueprintStack(ItemStack blueprintStack) {
        this.setInventorySlotContents(1, blueprintStack);
        this.decrStackSize(0, 1);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.worldObj.isRemote && this.mode == Mode.COPY && this.reader != null) {
            this.reader.iterate();
            if (this.reader.isDone()) {
                this.reader = null;
                this.sendNetworkUpdate();
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.worldObj.isRemote && !this.initialized) {
            if (!this.box.isInitialized()) {
                IAreaProvider a = Utils.getNearbyAreaProvider(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                if (a != null) {
                    this.mode = Mode.COPY;
                    this.box.initialize(a);
                    a.removeFromWorld();
                    this.sendNetworkUpdate();
                    return;
                }
                this.mode = Mode.NONE;
            } else {
                this.mode = Mode.COPY;
            }
            this.initialized = true;
            this.sendNetworkUpdate();
        }
    }

    public int getSizeInventory() {
        return 2;
    }

    public ItemStack getStackInSlot(int i) {
        return this.inv.getStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        ItemStack result = this.inv.decrStackSize(i, j);
        if (i == 0) {
            this.initializeBlueprint();
        }
        return result;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.inv.setInventorySlotContents(i, itemstack);
        if (i == 0) {
            this.initializeBlueprint();
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public String getInventoryName() {
        return "Template";
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.mode != Mode.NONE && this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.hasKey("box")) {
            this.box.initialize(nbt.getCompoundTag("box"));
        }
        this.inv.readFromNBT(nbt);
        this.mode = Mode.values()[nbt.getByte("mode")];
        this.name = nbt.getString("name");
        this.currentAuthorName = nbt.getString("lastAuthor");
        if (nbt.hasKey("readConfiguration")) {
            this.readConfiguration.readFromNBT(nbt.getCompoundTag("readConfiguration"));
        }
        NBTTagList subBptList = nbt.getTagList("subBlueprints", 10);
        for (int i = 0; i < subBptList.tagCount(); ++i) {
            BlockIndex index = new BlockIndex(subBptList.getCompoundTagAt(i));
            this.addSubBlueprint(index);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbt.setTag("box", (NBTBase)boxStore);
        }
        this.inv.writeToNBT(nbt);
        nbt.setByte("mode", (byte)this.mode.ordinal());
        nbt.setString("name", this.name);
        nbt.setString("lastAuthor", this.currentAuthorName);
        NBTTagCompound readConf = new NBTTagCompound();
        this.readConfiguration.writeToNBT(readConf);
        nbt.setTag("readConfiguration", (NBTBase)readConf);
        NBTTagList subBptList = new NBTTagList();
        for (BlockIndex b : this.subBlueprints) {
            NBTTagCompound subBpt = new NBTTagCompound();
            b.writeTo(subBpt);
            subBptList.appendTag((NBTBase)subBpt);
        }
        nbt.setTag("subBlueprints", (NBTBase)subBptList);
    }

    private boolean getIsWorking() {
        return this.mode == Mode.COPY ? this.reader != null : false;
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.box.writeData(stream);
        NetworkUtils.writeUTF(stream, this.name);
        stream.writeBoolean(this.getIsWorking());
        stream.writeByte(this.mode.ordinal());
        if (this.mode == Mode.COPY) {
            this.readConfiguration.writeData(stream);
            stream.writeShort(this.subLasers.size());
            for (LaserData ld : this.subLasers) {
                ld.writeData(stream);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.box.readData(stream);
        this.name = NetworkUtils.readUTF(stream);
        this.clientIsWorking = stream.readBoolean();
        this.mode = Mode.values()[stream.readByte()];
        if (this.mode == Mode.COPY) {
            this.readConfiguration.readData(stream);
            int size = stream.readUnsignedShort();
            this.subLasers.clear();
            for (int i = 0; i < size; ++i) {
                LaserData ld = new LaserData();
                ld.readData(stream);
                this.subLasers.add(ld);
            }
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.destroy();
    }

    private void initializeBlueprint() {
        if (this.getWorldObj().isRemote) {
            return;
        }
        if (this.mode == Mode.COPY) {
            this.reader = new RecursiveBlueprintReader(this);
        }
        this.sendNetworkUpdate();
    }

    public int getComputingProgressScaled(int scale) {
        if (this.reader != null) {
            return (int)(this.reader.getComputingProgressScaled() * (float)scale);
        }
        return 0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public boolean isItemValidForSlot(int var1, ItemStack var2) {
        return false;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box completeBox = new Box(this).extendToEncompass(this.box);
        for (LaserData d : this.subLasers) {
            completeBox.extendToEncompass(d.tail);
        }
        return completeBox.getBoundingBox();
    }

    public Packet getPacketSetName() {
        return new PacketCommand(this, "setName", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeUTF(data, TileArchitect.this.name);
            }
        });
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if ("setName".equals(command)) {
            this.name = NetworkUtils.readUTF(stream);
            if (side.isServer()) {
                BuildCraftCore.instance.sendToPlayersNear(this.getPacketSetName(), this);
            }
        } else if (side.isServer() && "setReadConfiguration".equals(command)) {
            this.readConfiguration.readData(stream);
            this.sendNetworkUpdate();
        }
    }

    public void rpcSetConfiguration(BlueprintReadConfiguration conf) {
        this.readConfiguration = conf;
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setReadConfiguration", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                TileArchitect.this.readConfiguration.writeData(data);
            }
        }));
    }

    public void addSubBlueprint(TileEntity sub) {
        if (this.mode == Mode.COPY) {
            this.addSubBlueprint(new BlockIndex(sub));
            this.sendNetworkUpdate();
        }
    }

    private void addSubBlueprint(BlockIndex index) {
        this.subBlueprints.add(index);
        LaserData laser = new LaserData(new Position(index), new Position(this));
        laser.head.x += 0.5;
        laser.head.y += 0.5;
        laser.head.z += 0.5;
        laser.tail.x += 0.5;
        laser.tail.y += 0.5;
        laser.tail.z += 0.5;
        this.subLasers.add(laser);
    }

    @Override
    public int getLEDLevel(int led) {
        boolean condition = false;
        switch (led) {
            case 0: {
                condition = this.clientIsWorking;
                break;
            }
            case 1: {
                condition = this.mode == Mode.COPY && this.box != null && this.box.isInitialized();
                break;
            }
            case 2: {
                condition = this.mode == Mode.EDIT;
            }
        }
        return condition ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return Double.MAX_VALUE;
    }

    public static enum Mode {
        NONE,
        EDIT,
        COPY;

    }
}

