/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.BlockIndex;
import buildcraft.builders.BuilderProxy;
import buildcraft.core.internal.IFramePipeConnection;
import buildcraft.core.lib.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFrame
extends Block
implements IFramePipeConnection {
    private static final ThreadLocal<Boolean> isRemovingFrames = new ThreadLocal();

    public BlockFrame() {
        super(Material.glass);
        this.setHardness(0.5f);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (world.isRemote) {
            return;
        }
        if (isRemovingFrames.get() == null) {
            this.removeNeighboringFrames(world, x, y, z);
        }
    }

    public void removeNeighboringFrames(World world, int x, int y, int z) {
        isRemovingFrames.set(true);
        ConcurrentSkipListSet<BlockIndex> frameCoords = new ConcurrentSkipListSet<BlockIndex>();
        frameCoords.add(new BlockIndex(x, y, z));
        while (frameCoords.size() > 0) {
            Iterator frameCoordIterator = frameCoords.iterator();
            while (frameCoordIterator.hasNext()) {
                BlockIndex i = (BlockIndex)frameCoordIterator.next();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Block nBlock = world.getBlock(i.x + dir.offsetX, i.y + dir.offsetY, i.z + dir.offsetZ);
                    if (nBlock != this) continue;
                    world.setBlockToAir(i.x + dir.offsetX, i.y + dir.offsetY, i.z + dir.offsetZ);
                    frameCoords.add(new BlockIndex(i.x + dir.offsetX, i.y + dir.offsetY, i.z + dir.offsetZ));
                }
                frameCoordIterator.remove();
            }
        }
        isRemovingFrames.remove();
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public Item getItemDropped(int i, Random random, int j) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public int getRenderType() {
        return BuilderProxy.frameRenderId;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        float xMin = 0.25f;
        float xMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i - 1, j, k)) {
            xMin = 0.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i + 1, j, k)) {
            xMax = 1.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j - 1, k)) {
            yMin = 0.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j + 1, k)) {
            yMax = 1.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j, k - 1)) {
            zMin = 0.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j, k + 1)) {
            zMax = 1.0f;
        }
        return AxisAlignedBB.getBoundingBox((double)((double)i + (double)xMin), (double)((double)j + (double)yMin), (double)((double)k + (double)zMin), (double)((double)i + (double)xMax), (double)((double)j + (double)yMax), (double)((double)k + (double)zMax));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return this.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public void addCollisionBoxesToList(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        this.setBlockBounds(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i - 1, j, k)) {
            this.setBlockBounds(0.0f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i + 1, j, k)) {
            this.setBlockBounds(0.25f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j - 1, k)) {
            this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.75f, 0.75f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j + 1, k)) {
            this.setBlockBounds(0.25f, 0.25f, 0.25f, 0.75f, 1.0f, 0.75f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j, k - 1)) {
            this.setBlockBounds(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.75f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j, k + 1)) {
            this.setBlockBounds(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
        float xMin = 0.25f;
        float xMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i - 1, j, k)) {
            xMin = 0.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i + 1, j, k)) {
            xMax = 1.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j - 1, k)) {
            yMin = 0.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j + 1, k)) {
            yMax = 1.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j, k - 1)) {
            zMin = 0.0f;
        }
        if (Utils.checkLegacyPipesConnections((IBlockAccess)world, i, j, k, i, j, k + 1)) {
            zMax = 1.0f;
        }
        this.setBlockBounds(xMin, yMin, zMin, xMax, yMax, zMax);
        MovingObjectPosition r = super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return r;
    }

    @Override
    public boolean isPipeConnected(IBlockAccess blockAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        return blockAccess.getBlock(x2, y2, z2) == this;
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Block)this));
    }

    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon("buildcraftbuilders:frameBlock/default");
    }
}

