/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.builders.ItemConstructionMarker;
import buildcraft.builders.TileBuilder;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.fluids.TankUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBuilder
extends BlockBuildCraft {
    @SideOnly(value=Side.CLIENT)
    public IIcon blockTopOn;

    public BlockBuilder() {
        super(Material.iron, BCCreativeTab.get("main"));
        this.setHardness(5.0f);
        this.setRotatable(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        super.registerBlockIcons(register);
        this.blockTopOn = register.registerIcon("buildcraftbuilders:builderBlock/top_on");
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileBuilder();
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        Item equipped;
        if (super.onBlockActivated(world, x, y, z, entityplayer, par6, par7, par8, par9)) {
            return true;
        }
        if (entityplayer.isSneaking()) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        TileBuilder builder = tile instanceof TileBuilder ? (TileBuilder)tile : null;
        Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof ItemConstructionMarker) {
            if (ItemConstructionMarker.linkStarted(entityplayer.getCurrentEquippedItem())) {
                ItemConstructionMarker.link(entityplayer.getCurrentEquippedItem(), world, x, y, z);
            }
            return true;
        }
        if (builder != null && TankUtils.handleRightClick(builder, ForgeDirection.UNKNOWN, entityplayer, true, false)) {
            return true;
        }
        if (!world.isRemote) {
            entityplayer.openGui((Object)BuildCraftBuilders.instance, 11, world, x, y, z);
        }
        return true;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 1;
    }
}

