/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.builders.ItemConstructionMarker;
import buildcraft.builders.TileArchitect;
import buildcraft.core.internal.ICustomLEDBlock;
import buildcraft.core.lib.block.BlockBuildCraft;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockArchitect
extends BlockBuildCraft
implements ICustomLEDBlock {
    public BlockArchitect() {
        super(Material.iron);
        this.setRotatable(true);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileArchitect();
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        Item equipped;
        if (super.onBlockActivated(world, x, y, z, entityplayer, par6, par7, par8, par9)) {
            return true;
        }
        Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof ItemConstructionMarker) {
            ItemConstructionMarker.link(entityplayer.getCurrentEquippedItem(), world, x, y, z);
            return true;
        }
        if (!world.isRemote) {
            entityplayer.openGui((Object)BuildCraftBuilders.instance, 10, world, x, y, z);
        }
        return true;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 1;
    }

    @Override
    public String[] getLEDSuffixes() {
        return new String[]{"led_red", "led_mode_copy", "led_mode_edit"};
    }
}

