/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.ResourceId;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceIdRequest
extends ResourceId {
    private BlockIndex index;
    private ForgeDirection side;
    private int slot;

    public ResourceIdRequest() {
    }

    public ResourceIdRequest(DockingStation station, int slot) {
        this.index = station.index();
        this.side = station.side();
        this.slot = slot;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceIdRequest compareId = (ResourceIdRequest)obj;
        return this.index.equals(compareId.index) && this.side.equals((Object)compareId.side) && this.slot == compareId.slot;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.index.hashCode()).append(this.side.hashCode()).append(this.slot).build();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.setTag("index", (NBTBase)indexNBT);
        nbt.setByte("side", (byte)this.side.ordinal());
        nbt.setInteger("localId", this.slot);
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.index = new BlockIndex(nbt.getCompoundTag("index"));
        this.side = ForgeDirection.getOrientation((int)nbt.getByte("side"));
        this.slot = nbt.getInteger("localId");
    }
}

