/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.Position;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class SchematicEntity
extends Schematic {
    public Class<? extends Entity> entity;
    public NBTTagCompound entityNBT = new NBTTagCompound();
    public ItemStack[] storedRequirements = new ItemStack[0];
    public BuildingPermission defaultPermission = BuildingPermission.ALL;

    @Override
    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
        Collections.addAll(requirements, this.storedRequirements);
    }

    public void writeToWorld(IBuilderContext context) {
        Entity e = EntityList.createEntityFromNBT((NBTTagCompound)this.entityNBT, (World)context.world());
        context.world().spawnEntityInWorld(e);
    }

    public void readFromWorld(IBuilderContext context, Entity entity) {
        entity.writeToNBTOptional(this.entityNBT);
    }

    @Override
    public void translateToBlueprint(Translation transform) {
        NBTTagList nbttaglist = this.entityNBT.getTagList("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos = transform.translate(pos);
        this.entityNBT.setTag("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
    }

    @Override
    public void translateToWorld(Translation transform) {
        NBTTagList nbttaglist = this.entityNBT.getTagList("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos = transform.translate(pos);
        this.entityNBT.setTag("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
    }

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
        registry.scanAndTranslateStacksToRegistry(this.entityNBT);
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        try {
            registry.scanAndTranslateStacksToWorld(this.entityNBT);
        }
        catch (MappingNotFoundException e) {
            this.entityNBT = new NBTTagCompound();
        }
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        NBTTagList nbttaglist = this.entityNBT.getTagList("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos = context.rotatePositionLeft(pos);
        this.entityNBT.setTag("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
        nbttaglist = this.entityNBT.getTagList("Rotation", 5);
        float yaw = nbttaglist.func_150308_e(0);
        this.entityNBT.setTag("Rotation", (NBTBase)this.newFloatNBTList(yaw += 90.0f, nbttaglist.func_150308_e(1)));
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.setInteger("entityId", registry.getIdForEntity(this.entity));
        nbt.setTag("entity", (NBTBase)this.entityNBT);
        NBTTagList rq = new NBTTagList();
        for (ItemStack stack : this.storedRequirements) {
            NBTTagCompound sub = new NBTTagCompound();
            stack.writeToNBT(stack.writeToNBT(sub));
            sub.setInteger("id", registry.getIdForItem(stack.getItem()));
            rq.appendTag((NBTBase)sub);
        }
        nbt.setTag("rq", (NBTBase)rq);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.entityNBT = nbt.getCompoundTag("entity");
        NBTTagList rq = nbt.getTagList("rq", 10);
        ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
        for (int i = 0; i < rq.tagCount(); ++i) {
            try {
                NBTTagCompound sub = rq.getCompoundTagAt(i);
                if (sub.getInteger("id") >= 0) {
                    sub.setInteger("id", Item.itemRegistry.getIDForObject((Object)registry.getItemForId(sub.getInteger("id"))));
                    rqs.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)sub));
                    continue;
                }
                this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
            }
        }
        this.storedRequirements = rqs.toArray(new ItemStack[rqs.size()]);
    }

    protected NBTTagList newDoubleNBTList(double ... par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble = par1ArrayOfDouble;
        int i = par1ArrayOfDouble.length;
        for (int j = 0; j < i; ++j) {
            double d1 = adouble[j];
            nbttaglist.appendTag((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatNBTList(float ... par1ArrayOfFloat) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat = par1ArrayOfFloat;
        int i = par1ArrayOfFloat.length;
        for (int j = 0; j < i; ++j) {
            float f1 = afloat[j];
            nbttaglist.appendTag((NBTBase)new NBTTagFloat(f1));
        }
        return nbttaglist;
    }

    public boolean isAlreadyBuilt(IBuilderContext context) {
        NBTTagList nbttaglist = this.entityNBT.getTagList("Pos", 6);
        Position newPosition = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        for (Object o : context.world().loadedEntityList) {
            Entity e = (Entity)o;
            Position existingPositon = new Position(e.posX, e.posY, e.posZ);
            if (!existingPositon.isClose(newPosition, 0.1f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int buildTime() {
        return 5;
    }

    @Override
    public BuildingPermission getBuildingPermission() {
        return this.defaultPermission;
    }
}

