/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockable;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityReinforcedChest
extends TileEntityLockable {
    private static ForgeDirection[] neighbors = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH};

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getResource() {
        return this.getMaterial().getChestResource(this.isConnected());
    }

    @Override
    public void setAttachmentPosition() {
        double x = !this.isConnected() ? 8 : (this.getOrientation() == ForgeDirection.WEST || this.getOrientation() == ForgeDirection.SOUTH ? 0 : 16);
        this.lockAttachment.setBox(x, 6.5, 0.5, 7.0, 7.0, 1.0);
    }

    @Override
    public int getColumns() {
        return BetterStorage.globalConfig.getInteger("general.reinforcedColumns");
    }

    @Override
    protected String getConnectableName() {
        return "container.betterstorage.reinforcedChest";
    }

    @Override
    public ForgeDirection[] getPossibleNeighbors() {
        return neighbors;
    }

    @Override
    public boolean canConnect(TileEntityConnectable connectable) {
        return connectable instanceof TileEntityReinforcedChest && super.canConnect(connectable) && (this.field_145851_c != connectable.field_145851_c && (this.getOrientation() == ForgeDirection.SOUTH || this.getOrientation() == ForgeDirection.NORTH) || this.field_145849_e != connectable.field_145849_e && (this.getOrientation() == ForgeDirection.EAST || this.getOrientation() == ForgeDirection.WEST));
    }
}

