/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.security.InvalidParameterException;
import net.mcft.copy.betterstorage.api.lock.EnumLockInteraction;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.api.lock.ILockable;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.attachment.LockAttachment;
import net.mcft.copy.betterstorage.tile.ContainerMaterial;
import net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityLockable
extends TileEntityConnectable
implements ILockable,
IHasAttachments {
    private boolean powered;
    public ContainerMaterial material;
    public LockAttachment lockAttachment;
    protected Attachments attachments = new Attachments(this);

    protected ItemStack getLockInternal() {
        return this.canHaveLock() ? this.lockAttachment.getItem() : null;
    }

    protected void setLockInternal(ItemStack lock) {
        this.lockAttachment.setItem(lock);
    }

    public TileEntityLockable() {
        if (!this.canHaveLock()) {
            return;
        }
        this.lockAttachment = this.attachments.add(LockAttachment.class);
        this.lockAttachment.setScale(0.5f, 1.5f);
        this.setAttachmentPosition();
    }

    public ContainerMaterial getMaterial() {
        if (!this.canHaveMaterial()) {
            return null;
        }
        if (this.material != null) {
            return this.material;
        }
        this.material = this.field_145850_b != null ? ContainerMaterial.get(this.func_145832_p()) : ContainerMaterial.iron;
        return this.material;
    }

    public boolean canHaveMaterial() {
        return true;
    }

    public boolean canHaveLock() {
        return true;
    }

    public abstract void setAttachmentPosition();

    @Override
    public Attachments getAttachments() {
        return ((TileEntityLockable)this.getMainTileEntity()).attachments;
    }

    @Override
    public void setOrientation(ForgeDirection orientation) {
        super.setOrientation(orientation);
        if (this.canHaveLock()) {
            this.lockAttachment.setDirection(orientation);
        }
    }

    @Override
    public void setConnected(ForgeDirection connected) {
        super.setConnected(connected);
        if (this.canHaveLock()) {
            this.setAttachmentPosition();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.attachments.update();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K && this.canHaveLock() && !this.canPlayerUseContainer(player)) {
            ((ILock)this.getLock().func_77973_b()).applyEffects(this.getLock(), this, player, EnumLockInteraction.OPEN);
        }
        return super.onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canPlayerUseContainer(EntityPlayer player) {
        return super.canPlayerUseContainer(player) && (this.getLock() == null || this.canUse(player));
    }

    @Override
    protected void onBlockPlacedBeforeCheckingConnections(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBeforeCheckingConnections(player, stack);
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.getMaterial(stack, ContainerMaterial.iron);
        }
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        if (!this.canHaveMaterial()) {
            return block;
        }
        return this.getMaterial().setMaterial(block);
    }

    @Override
    public void dropContents() {
        super.dropContents();
        if (!this.canHaveLock()) {
            return;
        }
        WorldUtils.dropStackFromBlock(this, this.getLock());
        this.setLock(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
        super.onBlockRenderAsItem(stack);
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.getMaterial(stack, ContainerMaterial.iron);
        }
    }

    @Override
    protected boolean isAccessible() {
        return this.getLock() == null;
    }

    @Override
    public boolean canConnect(TileEntityConnectable connectable) {
        if (!(connectable instanceof TileEntityLockable)) {
            return false;
        }
        TileEntityLockable lockable = (TileEntityLockable)connectable;
        return super.canConnect(connectable) && this.material == lockable.material && this.getLock() == null && lockable.getLock() == null;
    }

    @Override
    public ItemStack getLock() {
        return ((TileEntityLockable)this.getMainTileEntity()).getLockInternal();
    }

    @Override
    public boolean isLockValid(ItemStack lock) {
        return lock == null || lock.func_77973_b() instanceof ILock && this.canHaveLock();
    }

    @Override
    public void setLock(ItemStack lock) {
        if (!this.isLockValid(lock)) {
            throw new InvalidParameterException("Can't set lock to " + lock + ".");
        }
        TileEntityLockable main = (TileEntityLockable)this.getMainTileEntity();
        main.setLockInternal(lock);
        main.markForUpdate();
        this.func_70296_d();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return this.getMainTileEntity().getPlayersUsing() > 0;
    }

    @Override
    public void useUnlocked(EntityPlayer player) {
        this.openGui(player);
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    public boolean isPowered() {
        return ((TileEntityLockable)this.getMainTileEntity()).powered;
    }

    public void setPowered(boolean powered) {
        TileEntityLockable chest = (TileEntityLockable)this.getMainTileEntity();
        if (chest != this) {
            chest.setPowered(powered);
            return;
        }
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
        Block block = this.func_145838_q();
        if (powered) {
            this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, block, 10);
        }
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, block);
        this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, block);
        this.field_145850_b.func_147459_d(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, block);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, block);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, block);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, block);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, block);
        if (this.isConnected() && this.getConnected() == ForgeDirection.EAST) {
            this.field_145850_b.func_147459_d(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, block);
            this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e, block);
            this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, block);
            this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1, block);
            this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1, block);
        }
        if (this.isConnected() && this.getConnected() == ForgeDirection.SOUTH) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, block);
            this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1, block);
            this.field_145850_b.func_147459_d(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1, block);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1, block);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, block);
        }
    }

    @Override
    public NBTTagCompound getDescriptionPacketData(NBTTagCompound compound) {
        ItemStack lock;
        compound = super.getDescriptionPacketData(compound);
        if (this.canHaveMaterial()) {
            compound.func_74778_a("Material", this.getMaterial().name);
        }
        if (this.canHaveLock() && (lock = this.getLockInternal()) != null) {
            compound.func_74782_a("lock", (NBTBase)lock.func_77955_b(new NBTTagCompound()));
        }
        return compound;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound compound = packet.func_148857_g();
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.get(compound.func_74779_i("Material"));
        }
        if (this.canHaveLock()) {
            if (!compound.func_74764_b("lock")) {
                this.setLockInternal(null);
            } else {
                this.setLockInternal(ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("lock")));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.get(compound.func_74779_i("Material"));
        }
        if (this.canHaveLock() && compound.func_74764_b("lock")) {
            this.setLockInternal(ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("lock")));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        ItemStack lock;
        super.func_145841_b(compound);
        if (this.canHaveMaterial()) {
            compound.func_74778_a("Material", this.getMaterial().name);
        }
        if (this.canHaveLock() && (lock = this.getLockInternal()) != null) {
            compound.func_74782_a("lock", (NBTBase)lock.func_77955_b(new NBTTagCompound()));
        }
    }
}

