/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import java.util.HashSet;
import java.util.Set;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.crate.ICrateWatcher;
import net.mcft.copy.betterstorage.inventory.InventoryCrateBlockView;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.misc.Region;
import net.mcft.copy.betterstorage.tile.crate.CrateItems;
import net.mcft.copy.betterstorage.tile.crate.CratePileCollection;
import net.mcft.copy.betterstorage.tile.crate.CratePileMap;
import net.mcft.copy.betterstorage.tile.crate.TileEntityCrate;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CratePileData {
    private static final int maxCratePileSize = 8192;
    public final CratePileCollection collection;
    public final int id;
    private CrateItems contents = new CrateItems();
    private int numCrates = 0;
    private boolean destroyed = false;
    private boolean dirty = false;
    private CratePileMap map;
    private Set<ICrateWatcher> watchers = new HashSet<ICrateWatcher>();
    public final InventoryCrateBlockView blockView = new InventoryCrateBlockView(this);

    public CrateItems getContents() {
        return this.contents;
    }

    public int getNumCrates() {
        return this.numCrates;
    }

    public int getCapacity() {
        return this.numCrates * 18;
    }

    public int getUniqueItems() {
        return this.contents.getUniqueItems();
    }

    public int getOccupiedSlots() {
        return this.contents.getTotalStacks();
    }

    public int getFreeSlots() {
        return this.getCapacity() - this.getOccupiedSlots();
    }

    public Region getRegion() {
        return this.map.region;
    }

    public int getCenterX() {
        return (this.map.region.minX + this.map.region.maxX) / 2;
    }

    public int getCenterY() {
        return (this.map.region.minY + this.map.region.maxY) / 2;
    }

    public int getCenterZ() {
        return (this.map.region.minZ + this.map.region.maxZ) / 2;
    }

    public CratePileData(CratePileCollection collection, int id, int numCrates) {
        this.collection = collection;
        this.id = id;
        this.numCrates = numCrates;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        if (this.isDirty() || this.destroyed) {
            return;
        }
        this.dirty = true;
        if (BetterStorage.globalConfig.getBoolean("general.crateDebugMessages")) {
            BetterStorage.log.info(String.format("[CRATE DEBUG] Marked crate pile at [%s,%s,%s] as dirty.", this.getCenterX(), this.getCenterY(), this.getCenterZ()));
        }
    }

    public void save() {
        if (!this.isDirty()) {
            return;
        }
        this.collection.save(this);
        this.dirty = false;
        if (BetterStorage.globalConfig.getBoolean("general.crateDebugMessages")) {
            BetterStorage.log.info(String.format("[CRATE DEBUG] Saved crate pile at [%s,%s,%s].", this.getCenterX(), this.getCenterY(), this.getCenterZ()));
        }
    }

    public void remove() {
        this.destroyed = true;
        this.collection.removeCratePile(this);
        if (BetterStorage.globalConfig.getBoolean("general.crateDebugMessages")) {
            BetterStorage.log.info(String.format("[CRATE DEBUG] Removed empty crate pile at [%s,%s,%s].", this.getCenterX(), this.getCenterY(), this.getCenterZ()));
        }
    }

    public boolean canAdd(TileEntityCrate crate) {
        return !(this.map == null || this.numCrates >= 8192 || !this.map.region.contains(crate) && !this.canExpand(crate) || !this.map.get(crate.field_145851_c, crate.field_145848_d - 1, crate.field_145849_e) && crate.field_145848_d != this.map.region.minY);
    }

    private boolean canExpand(TileEntityCrate crate) {
        int volume = this.map.region.volume();
        if (this.numCrates < Math.min((int)((double)volume * 0.8), volume - 5)) {
            return false;
        }
        if (crate.field_145851_c < this.map.region.minX || crate.field_145851_c > this.map.region.maxX) {
            int maxDiff;
            int n = maxDiff = this.map.region.height() == 1 ? 1 : 3;
            if (this.map.region.width() >= maxDiff + Math.min(this.map.region.height(), this.map.region.depth())) {
                return false;
            }
        } else if (crate.field_145849_e < this.map.region.minZ || crate.field_145849_e > this.map.region.maxZ) {
            int maxDiff;
            int n = maxDiff = this.map.region.width() == 1 ? 1 : 3;
            if (this.map.region.height() >= maxDiff + Math.min(this.map.region.width(), this.map.region.depth())) {
                return false;
            }
        } else if (crate.field_145848_d < this.map.region.minY || crate.field_145848_d > this.map.region.maxY) {
            int maxDiff;
            int n = maxDiff = this.map.region.width() == 1 || this.map.region.height() == 1 ? 1 : 4;
            if (this.map.region.depth() >= maxDiff + Math.min(this.map.region.width(), this.map.region.height())) {
                return false;
            }
        }
        return true;
    }

    public void trimMap() {
        if (this.map != null) {
            this.map.trim();
        }
    }

    public void addCrate(TileEntityCrate crate) {
        if (this.numCrates == 0) {
            this.map = new CratePileMap(crate);
        }
        this.map.add(crate);
        ++this.numCrates;
        this.markDirty();
    }

    public void removeCrate(TileEntityCrate crate) {
        if (--this.numCrates > 0) {
            if (this.map != null) {
                this.map.remove(crate);
            }
            this.markDirty();
        } else {
            this.remove();
        }
    }

    public boolean hasCrate(int x, int y, int z) {
        return this.map.get(x, y, z);
    }

    public ItemStack addItems(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack overflow = null;
        int space = this.getSpaceForItem(stack);
        if (space > 0) {
            if (space < stack.field_77994_a) {
                overflow = stack.func_77979_a(stack.field_77994_a - space);
            }
            ItemIdentifier item = new ItemIdentifier(stack);
            this.getContents().set(item, this.getContents().get(item) + stack.field_77994_a);
            for (ICrateWatcher watcher : this.watchers) {
                watcher.onCrateItemsModified(stack);
            }
        } else {
            overflow = stack;
        }
        this.markDirty();
        return overflow;
    }

    public ItemStack removeItems(ItemIdentifier item, int amount) {
        int currentAmount = this.getContents().get(item);
        if ((amount = Math.min(amount, currentAmount)) <= 0) {
            return null;
        }
        this.getContents().set(item, currentAmount - amount);
        ItemStack removedStack = item.createStack(-amount);
        for (ICrateWatcher watcher : this.watchers) {
            watcher.onCrateItemsModified(removedStack);
        }
        this.markDirty();
        return item.createStack(amount);
    }

    public ItemStack removeItems(ItemStack stack) {
        return this.removeItems(new ItemIdentifier(stack), stack.field_77994_a);
    }

    public int getSpaceForItem(ItemIdentifier item) {
        if (item == null) {
            return 0;
        }
        int amount = this.getContents().get(item);
        ItemStack testStack = item.createStack(amount);
        int maxStackSize = testStack.func_77976_d();
        int space = this.getFreeSlots() * maxStackSize;
        if (amount > 0) {
            space += StackUtils.calcNumStacks(testStack) * maxStackSize - testStack.field_77994_a;
        }
        return space;
    }

    public int getSpaceForItem(ItemStack item) {
        if (item == null) {
            return 0;
        }
        return this.getSpaceForItem(new ItemIdentifier(item));
    }

    public void addWatcher(ICrateWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void removeWatcher(ICrateWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("numCrates", (short)this.getNumCrates());
        NBTTagList stacks = new NBTTagList();
        for (ItemStack stack : this.getContents().getItems()) {
            NBTTagCompound stackCompound = new NBTTagCompound();
            stackCompound.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
            stackCompound.func_74768_a("Count", stack.field_77994_a);
            stackCompound.func_74777_a("Damage", (short)StackUtils.getRealItemDamage(stack));
            if (stack.func_77942_o()) {
                stackCompound.func_74782_a("tag", (NBTBase)stack.func_77978_p());
            }
            stacks.func_74742_a((NBTBase)stackCompound);
        }
        compound.func_74782_a("stacks", (NBTBase)stacks);
        if (this.map != null) {
            compound.func_74782_a("map", (NBTBase)this.map.toCompound());
        }
        return compound;
    }

    public static CratePileData fromCompound(CratePileCollection collection, int crateId, NBTTagCompound compound) {
        short numCrates = compound.func_74765_d("numCrates");
        CratePileData pileData = new CratePileData(collection, crateId, numCrates);
        NBTTagList stacks = compound.func_150295_c("stacks", 10);
        for (int j = 0; j < stacks.func_74745_c(); ++j) {
            NBTTagCompound stackCompound = stacks.func_150305_b(j);
            Item item = Item.func_150899_d((int)stackCompound.func_74765_d("id"));
            int count = stackCompound.func_74762_e("Count");
            short damage = stackCompound.func_74765_d("Damage");
            ItemStack stack = new ItemStack(item, count, (int)damage);
            if (stackCompound.func_74764_b("tag")) {
                stack.field_77990_d = stackCompound.func_74775_l("tag");
            }
            if (stack.func_77973_b() == null) continue;
            pileData.getContents().set(new ItemIdentifier(stack), stack.field_77994_a);
        }
        if (compound.func_74764_b("map")) {
            pileData.map = CratePileMap.fromCompound(compound.func_74775_l("map"));
        }
        return pileData;
    }
}

