/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import java.util.List;
import java.util.Random;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.tile.ContainerMaterial;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockable;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileLockable
extends TileContainerBetterStorage {
    protected TileLockable(Material material) {
        super(material);
    }

    public boolean hasMaterial() {
        return true;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        if (!this.hasMaterial()) {
            super.func_149666_a(item, tab, list);
        } else {
            for (ContainerMaterial material : ContainerMaterial.getMaterials()) {
                list.add(material.setMaterial(new ItemStack(item, 1, 0)));
            }
        }
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (this.hasMaterial() && !player.field_71075_bZ.field_75098_d) {
            this.func_149642_a(world, x, y, z, WorldUtils.get((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityLockable.class).material.setMaterial(new ItemStack((Block)this, 1, 0)));
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (this.hasMaterial()) {
            this.func_149642_a(world, x, y, z, WorldUtils.get((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityLockable.class).material.setMaterial(new ItemStack((Block)this, 1, 0)));
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return this.hasMaterial() ? 0 : 1;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntityLockable lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockable.class);
        if (lockable != null && lockable.getLock() != null) {
            return -1.0f;
        }
        return super.func_149712_f(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int persistance;
        float modifier = 1.0f;
        TileEntityLockable lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockable.class);
        if (lockable != null && (persistance = BetterStorageEnchantment.getLevel(lockable.getLock(), "persistance")) > 0) {
            modifier = (float)((double)modifier + Math.pow(2.0, persistance));
        }
        return super.func_149638_a(entity) * modifier;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class).getAttachments().rayTrace(world, x, y, z, start, end);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        Attachments attachments = WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class).getAttachments();
        boolean abort = attachments.interact(WorldUtils.rayTrace(player, 1.0f), player, EnumAttachmentInteraction.attack);
    }

    public boolean func_149740_M() {
        return true;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return WorldUtils.get(world, x, y, z, TileEntityLockable.class).isPowered() ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockable.class).setPowered(false);
    }
}

