/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.cardboard;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.RecipeBounds;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputItemStack;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputOreDict;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.item.cardboard.CardboardRecipeHelper;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.item.cardboard.RecipeInputCardboard;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CardboardRepairRecipe
implements IStationRecipe {
    private static final IRecipeInput sheetUsed = new RecipeInputOreDict("sheetCardboard", 1);
    private static final IRecipeInput sheetUnused = new RecipeInputOreDict("sheetCardboard", 0);

    @Override
    public StationCrafting checkMatch(ItemStack[] input, RecipeBounds bounds) {
        boolean hasCardboardItems = false;
        int numSheets = 0;
        int totalDamage = 0;
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ICardboardItem) {
                hasCardboardItems = true;
                totalDamage += stack.func_77960_j();
                continue;
            }
            if (sheetUsed.matches(stack)) {
                ++numSheets;
                continue;
            }
            return null;
        }
        if (!hasCardboardItems || numSheets <= 0) {
            return null;
        }
        int numSheetsNeeded = (totalDamage + 79) / 80;
        if (numSheetsNeeded > numSheets) {
            return null;
        }
        ItemStack[] output = new ItemStack[9];
        int experienceCost = 0;
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null) continue;
            ItemStack outputStack = null;
            if (stack.func_77973_b() instanceof ICardboardItem) {
                Collection<StackUtils.StackEnchantment> enchantments = StackUtils.getEnchantments(stack).values();
                experienceCost += Math.max(enchantments.size() - 1, 0);
                for (StackUtils.StackEnchantment ench : enchantments) {
                    experienceCost += this.calculateCost(ench);
                }
                outputStack = StackUtils.copyStack(stack, 1);
                outputStack.func_77964_b(0);
                ItemStack requiredStack = outputStack.func_77946_l();
                requiredStack.func_77964_b(Short.MAX_VALUE);
                requiredStack.func_77982_d(null);
                requiredInput[i] = new RecipeInputItemStack(requiredStack);
            } else {
                requiredInput[i] = numSheetsNeeded-- > 0 ? sheetUsed : sheetUnused;
            }
            output[i] = outputStack;
        }
        return new StationCrafting(output, requiredInput, experienceCost);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IRecipeInput[]> getSampleInputs() {
        ArrayList<IRecipeInput[]> sampleInputs = new ArrayList<IRecipeInput[]>();
        if (BetterStorageItems.cardboardPickaxe != null) {
            ItemStack stack = new ItemStack((Item)BetterStorageItems.cardboardPickaxe, 1, 32);
            stack.func_77966_a(Enchantment.field_77349_p, 5);
            stack.func_77966_a(Enchantment.field_77347_r, 3);
            this.makeInput(sampleInputs, new Object[]{stack, BetterStorageItems.cardboardSheet});
        }
        this.makeInput(sampleInputs, new Object[]{new ItemStack((Item)BetterStorageItems.cardboardPickaxe, 1, 32), BetterStorageItems.cardboardSheet});
        this.makeInput(sampleInputs, new Object[]{new ItemStack((Item)BetterStorageItems.cardboardHelmet, 1, 11), new ItemStack((Item)BetterStorageItems.cardboardChestplate, 1, 16), BetterStorageItems.cardboardSheet, new ItemStack((Item)BetterStorageItems.cardboardLeggings, 1, 15), new ItemStack((Item)BetterStorageItems.cardboardBoots, 1, 13)});
        this.makeInput(sampleInputs, new Object[]{new ItemStack((Item)BetterStorageItems.cardboardHelmet, 1, 22), new ItemStack((Item)BetterStorageItems.cardboardChestplate, 1, 32), BetterStorageItems.cardboardSheet, new ItemStack((Item)BetterStorageItems.cardboardLeggings, 1, 30), new ItemStack((Item)BetterStorageItems.cardboardBoots, 1, 26), BetterStorageItems.cardboardSheet});
        this.makeInput(sampleInputs, new Object[]{new ItemStack((Item)BetterStorageItems.cardboardHelmet, 1, 33), new ItemStack((Item)BetterStorageItems.cardboardChestplate, 1, 48), BetterStorageItems.cardboardSheet, new ItemStack((Item)BetterStorageItems.cardboardLeggings, 1, 45), new ItemStack((Item)BetterStorageItems.cardboardBoots, 1, 39), BetterStorageItems.cardboardSheet, new ItemStack((Item)BetterStorageItems.cardboardShovel, 1, 32), new ItemStack((Item)BetterStorageItems.cardboardHoe, 1, 32), BetterStorageItems.cardboardSheet});
        return sampleInputs;
    }

    private void makeInput(List<IRecipeInput[]> sampleInputs, Object ... obj) {
        IRecipeInput[] input = new IRecipeInput[9];
        boolean hasCardboardItem = false;
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) continue;
            if (obj[i] instanceof ItemStack) {
                Item item = ((ItemStack)obj[i]).func_77973_b();
                if (item == null) continue;
                if (item instanceof ICardboardItem) {
                    hasCardboardItem = true;
                }
            }
            input[i] = BetterStorageCrafting.makeInput(obj[i]);
        }
        if (hasCardboardItem) {
            sampleInputs.add(input);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IRecipeInput> getPossibleInputs() {
        return Arrays.asList(RecipeInputCardboard.instance, new RecipeInputItemStack(new ItemStack((Item)BetterStorageItems.cardboardSheet)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getPossibleOutputs() {
        return Collections.emptyList();
    }

    private int calculateCost(StackUtils.StackEnchantment ench) {
        int cost = 0;
        int weight = ench.ench.func_77324_c();
        int level = ench.getLevel();
        cost = weight > 8 ? (cost += Math.max(level - 2, 0)) : (weight > 4 ? (cost += level - 1) : (weight > 2 ? (cost += level) : level * 2));
        return cost += CardboardRecipeHelper.getAdditionalEnchantmentCost(ench);
    }
}

