/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import invtweaks.api.container.InventoryContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.container.SlotBetterStorage;
import net.mcft.copy.betterstorage.container.SlotStationOutput;
import net.mcft.copy.betterstorage.inventory.InventoryCraftingStation;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@InventoryContainer
public class ContainerCraftingStation
extends ContainerBetterStorage {
    public InventoryCraftingStation inv;
    private int lastOutputIsReal = 0;
    private int lastProgress = 0;

    public ContainerCraftingStation(EntityPlayer player, IInventory inventory) {
        super(player, inventory, 9, 2);
    }

    @ContainerSectionCallback
    @SideOnly(value=Side.CLIENT)
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        HashMap<ContainerSection, List<Slot>> map = new HashMap<ContainerSection, List<Slot>>();
        map.put(ContainerSection.CHEST, this.field_75151_b.subList(17, 17 + this.getRows() * this.getColumns()));
        return map;
    }

    @Override
    public int getHeight() {
        return 209;
    }

    @Override
    protected void setupInventoryContainer() {
        int x;
        int y;
        this.inv = this.inventory instanceof InventoryCraftingStation ? (InventoryCraftingStation)this.inventory : (InventoryCraftingStation)((InventoryTileEntity)this.inventory).inventory;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotBetterStorage(this, this.inventory, x + y * 3, 17 + x * 18, 17 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotStationOutput(this, this.inventory, 9 + x + y * 3, 107 + x * 18, 17 + y * 18));
            }
        }
        for (y = 0; y < this.getRows(); ++y) {
            for (x = 0; x < this.getColumns(); ++x) {
                this.func_75146_a(new SlotBetterStorage(this, this.inventory, 18 + x + y * this.getColumns(), 8 + x * 18, 76 + y * 18));
            }
        }
    }

    @Override
    protected boolean inInventory(int slot) {
        return super.inInventory(slot) && slot >= 9;
    }

    @Override
    protected int transferStart(int slot) {
        return !this.inInventory(slot) ? 18 : super.transferStart(slot);
    }

    public void func_75142_b() {
        super.func_75142_b();
        int outputIsReal = this.inv.outputIsReal ? 1 : 0;
        this.sendUpdateIfChanged(0, outputIsReal, this.lastOutputIsReal);
        this.lastOutputIsReal = outputIsReal;
        int progress = this.inv.currentCrafting != null ? Math.min(this.inv.progress, this.inv.currentCrafting.getCraftingTime()) : 0;
        this.sendUpdateIfChanged(1, progress, this.lastProgress);
        this.lastProgress = progress;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int val) {
        if (id == 0) {
            this.inv.outputIsReal = val != 0;
        } else if (id == 1) {
            this.inv.progress = val;
        }
    }

    @Override
    public ItemStack func_75144_a(int slotId, int button, int special, EntityPlayer player) {
        if (!this.inv.outputIsReal && this.inv.currentCrafting != null && slotId >= 9 && slotId < 18 && this.inv.output[slotId - 9] != null && this.inv.canTake(player) && special != 3) {
            ItemStack craftingStack = this.inv.output[slotId - 9];
            int amount = craftingStack.field_77994_a;
            if (special == 1) {
                ItemStack stack;
                int count = 0;
                do {
                    this.inv.craft(player);
                    stack = super.func_75144_a(slotId, button, special, player);
                } while (!this.inv.outputIsReal && this.inv.currentCrafting != null && this.inv.output[slotId - 9] != null && this.inv.canTake(player) && (stack == null || StackUtils.matches(stack, this.inv.output[slotId - 9])) && this.inv.hasItemRequirements() && (count += amount) + amount <= craftingStack.func_77976_d());
                return stack;
            }
            if (special < 2) {
                ItemStack holding = player.field_71071_by.func_70445_o();
                if (holding == null || StackUtils.matches(holding, craftingStack) && holding.field_77994_a <= holding.func_77976_d() - amount) {
                    this.inv.craft(player);
                }
            } else {
                return craftingStack;
            }
        }
        return super.func_75144_a(slotId, button, special, player);
    }

    @Override
    public void onSlotChanged(int slot) {
        if (slot < 9) {
            this.inv.inputChanged();
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return super.func_94530_a(stack, slot) && (slot.field_75222_d < 9 || slot.field_75222_d >= 18);
    }
}

