/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.config.setting;

import cpw.mods.fml.client.config.ConfigGuiType;
import net.mcft.copy.betterstorage.config.Config;
import net.mcft.copy.betterstorage.config.setting.SinglePropertySetting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class DoubleSetting
extends SinglePropertySetting<Double> {
    protected double minValue = Double.MIN_VALUE;
    protected double maxValue = Double.MAX_VALUE;

    public DoubleSetting(Config config, String fullName, Double defaultValue) {
        super(config, fullName, defaultValue, ConfigGuiType.DOUBLE);
    }

    public DoubleSetting(Config config, String fullName, Double defaultValue, String langKey) {
        super(config, fullName, defaultValue, ConfigGuiType.DOUBLE, langKey);
    }

    public DoubleSetting(Config config, String fullName) {
        this(config, fullName, 0.0);
    }

    public DoubleSetting(Config config, String fullName, String langKey) {
        this(config, fullName, 0.0, langKey);
    }

    public DoubleSetting setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    public DoubleSetting setSynced() {
        super.setSynced();
        return this;
    }

    public DoubleSetting setValidRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    @Override
    public String validateInternal(Double value) {
        if (value < this.minValue || value > this.maxValue) {
            return String.format("Value %s is not in valid range, %s to %s", value, this.minValue, this.maxValue);
        }
        return null;
    }

    @Override
    protected Property.Type getPropertyType() {
        return Property.Type.DOUBLE;
    }

    @Override
    protected Double loadInternal(Configuration config) {
        return this.getProperty(config).getDouble(((Double)this.defaultValue).doubleValue());
    }

    @Override
    protected void saveInternal(Configuration config, Double value) {
        this.getProperty(config).set(value.doubleValue());
    }

    @Override
    protected Double readInternal(NBTTagCompound compound) {
        return compound.func_74769_h(this.fullName);
    }

    @Override
    protected void writeInternal(NBTTagCompound compound, Double value) {
        compound.func_74780_a(this.fullName, value.doubleValue());
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }
}

