/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.renderer;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.tile.entity.TileEntityReinforcedChest;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityReinforcedChestRenderer
extends TileEntitySpecialRenderer {
    private ModelChest chestModel = new ModelChest();
    private ModelChest largeChestModel = new ModelLargeChest();

    public void renderTileEntityAt(TileEntityReinforcedChest chest, double x, double y, double z, float partialTicks) {
        boolean large = chest.isConnected();
        if (large && !chest.isMain()) {
            return;
        }
        ModelChest model = large ? this.largeChestModel : this.chestModel;
        this.func_147499_a(chest.getResource());
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glPushMatrix();
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)-0.5f, (float)-0.5f);
        int rotation = DirectionUtils.getRotation(chest.getOrientation());
        if (rotation == 180 && large) {
            GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotation == 270 && large) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        }
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float angle = chest.prevLidAngle + (chest.lidAngle - chest.prevLidAngle) * partialTicks;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        model.field_78234_a.field_78795_f = -((float)((double)angle * Math.PI / 2.0));
        model.func_78231_a();
        GL11.glPopMatrix();
        chest.getAttachments().render(partialTicks);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity entity, double x, double y, double z, float partialTicks) {
        this.renderTileEntityAt((TileEntityReinforcedChest)entity, x, y, z, partialTicks);
    }
}

