/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.addon.thaumcraft;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.addon.Addon;
import net.mcft.copy.betterstorage.addon.thaumcraft.ItemThaumcraftBackpack;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileEntityThaumcraftBackpack;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileEntityThaumiumChest;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileThaumcraftBackpack;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileThaumiumChest;
import net.mcft.copy.betterstorage.client.renderer.ItemRendererBackpack;
import net.mcft.copy.betterstorage.client.renderer.TileEntityReinforcedChestRenderer;
import net.mcft.copy.betterstorage.config.setting.BooleanSetting;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class ThaumcraftAddon
extends Addon {
    public static final String thaumcraftBackpackEnabled = "tile.thaumcraftBackpack";
    public static final String thaumiumChestEnabled = "tile.thaumiumChest";
    public static TileBackpack thaumcraftBackpack;
    public static TileThaumiumChest thaumiumChest;
    public static ItemThaumcraftBackpack itemThaumcraftBackpack;
    public static int thaumiumChestRenderId;
    public static ItemStack thaumium;
    public static ItemStack thaumiumBlock;
    public static ItemStack fabric;
    public static InfusionRecipe thaumcraftBackpackRecipe;
    public static InfusionRecipe thaumiumChestRecipe;

    public ThaumcraftAddon() {
        super("Thaumcraft");
    }

    @Override
    public void setupConfig() {
        new BooleanSetting(BetterStorage.globalConfig, thaumcraftBackpackEnabled, true);
        new BooleanSetting(BetterStorage.globalConfig, thaumiumChestEnabled, true);
    }

    @Override
    public void initializeBlocks() {
        thaumcraftBackpack = MiscUtils.conditionalNew(TileThaumcraftBackpack.class, thaumcraftBackpackEnabled);
        thaumiumChest = MiscUtils.conditionalNew(TileThaumiumChest.class, thaumiumChestEnabled);
    }

    @Override
    public void initializeItems() {
        itemThaumcraftBackpack = MiscUtils.conditionalNew(ItemThaumcraftBackpack.class, thaumcraftBackpackEnabled);
    }

    @Override
    public void addRecipes() {
        thaumium = ItemApi.getItem((String)"itemResource", (int)2);
        thaumiumBlock = ItemApi.getBlock((String)"blockCosmeticSolid", (int)4);
        fabric = ItemApi.getItem((String)"itemResource", (int)7);
        ItemStack log = new ItemStack(Blocks.field_150364_r);
        if (thaumcraftBackpack != null && BetterStorageTiles.backpack != null) {
            thaumcraftBackpackRecipe = ThaumcraftApi.addInfusionCraftingRecipe((String)"betterstorage.magicstorage", (Object)new ItemStack((Item)itemThaumcraftBackpack), (int)1, (AspectList)ThaumcraftAddon.createAspectList(Aspect.VOID, 16, Aspect.EXCHANGE, 12, Aspect.MAGIC, 10), (ItemStack)new ItemStack((Item)BetterStorageItems.itemBackpack), (ItemStack[])new ItemStack[]{thaumium, fabric, fabric, fabric});
        }
        if (thaumiumChest != null && BetterStorageTiles.reinforcedChest != null) {
            thaumiumChestRecipe = ThaumcraftApi.addInfusionCraftingRecipe((String)"betterstorage.magicstorage", (Object)new ItemStack((Block)thaumiumChest), (int)4, (AspectList)ThaumcraftAddon.createAspectList(Aspect.METAL, 16, Aspect.VOID, 20, Aspect.MAGIC, 16), (ItemStack)new ItemStack((Block)BetterStorageTiles.reinforcedChest), (ItemStack[])new ItemStack[]{thaumiumBlock, thaumium, log, thaumium, log, thaumium});
        }
    }

    private void addItemAspects() {
        ThaumcraftAddon.addAspectsFor(BetterStorageTiles.crate, -1, true, Aspect.VOID, 3);
        ThaumcraftAddon.addAspectsFor(BetterStorageTiles.locker, -1, true, Aspect.VOID, 4);
        ThaumcraftAddon.addAspectsFor(BetterStorageTiles.reinforcedChest, -1, true, Aspect.VOID, 5, Aspect.METAL, 10, Aspect.ARMOR, 6);
        ThaumcraftAddon.addAspectsFor(BetterStorageTiles.craftingStation, -1, true, Aspect.CRAFT, 6, Aspect.MECHANISM, 4);
        ThaumcraftAddon.addAspectsFor((Item)BetterStorageItems.itemBackpack, -1, true, Aspect.VOID, 4, Aspect.EXCHANGE, 6);
        ThaumcraftAddon.addAspectsFor((Item)BetterStorageItems.itemEnderBackpack, -1, true, Aspect.DARKNESS, 8, Aspect.VOID, 4, Aspect.EXCHANGE, 8, Aspect.TRAVEL, 4, Aspect.ELDRITCH, 4, Aspect.MAGIC, 4);
        ThaumcraftAddon.addAspectsFor(BetterStorageItems.cardboardSheet, -1, false, Aspect.CRAFT, 1);
        ThaumcraftAddon.addAspectsFor(BetterStorageTiles.cardboardBox, -1, true, Aspect.VOID, 2, Aspect.TRAVEL, 2);
        ThaumcraftAddon.addAspectsFor(BetterStorageItems.key, -1, false, Aspect.GREED, 5, Aspect.METAL, 4, Aspect.TOOL, 2);
        ThaumcraftAddon.addAspectsFor(BetterStorageItems.lock, -1, false, Aspect.GREED, 4, Aspect.METAL, 6, Aspect.MECHANISM, 6, Aspect.ARMOR, 8);
        ThaumcraftAddon.addAspectsFor(BetterStorageItems.keyring, -1, false, Aspect.GREED, 1, Aspect.METAL, 2, Aspect.TOOL, 1);
        ThaumcraftAddon.addAspectsFor((Item)BetterStorageItems.drinkingHelmet, -1, true, Aspect.ARMOR, 2, Aspect.MECHANISM, 5, Aspect.ENERGY, 6);
        ThaumcraftAddon.addAspectsFor(BetterStorageItems.slimeBucket, -1, false, Aspect.METAL, 8, Aspect.VOID, 1, Aspect.SLIME, 4);
    }

    private void addEntityAspects() {
        ThaumcraftAddon.addAspectsFor("betterstorage.Frienderman", Aspect.ELDRITCH, 4, Aspect.TRAVEL, 4, Aspect.EXCHANGE, 2);
        ThaumcraftAddon.addAspectsFor("betterstorage.Cluckington", Aspect.BEAST, 2, Aspect.FLIGHT, 2, Aspect.WEAPON, 1);
    }

    private static void addAspectsFor(Block block, int meta, boolean add, Object ... aspects) {
        if (block != null) {
            AspectList list = ThaumcraftAddon.createAspectList(aspects);
            if (add) {
                ThaumcraftApi.registerComplexObjectTag((ItemStack)new ItemStack(block, meta), (AspectList)list);
            } else {
                ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(block, meta), (AspectList)list);
            }
        }
    }

    private static void addAspectsFor(Item item, int meta, boolean add, Object ... aspects) {
        if (item != null) {
            AspectList list = ThaumcraftAddon.createAspectList(aspects);
            if (add) {
                ThaumcraftApi.registerComplexObjectTag((ItemStack)new ItemStack(item, meta), (AspectList)list);
            } else {
                ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item, meta), (AspectList)list);
            }
        }
    }

    private static void addAspectsFor(String entityName, Object ... aspects) {
        ThaumcraftApi.registerEntityTag((String)entityName, (AspectList)ThaumcraftAddon.createAspectList(aspects), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }

    public static AspectList createAspectList(Object ... aspects) {
        AspectList list = new AspectList();
        for (int i = 0; i < aspects.length; i += 2) {
            list.add((Aspect)aspects[i], ((Integer)aspects[i + 1]).intValue());
        }
        return list;
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityThaumcraftBackpack.class, (String)"container.betterstorage.thaumcraftBackpack");
        GameRegistry.registerTileEntity(TileEntityThaumiumChest.class, (String)"container.betterstorage.thaumiumChest");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        if (thaumcraftBackpack != null) {
            MinecraftForgeClient.registerItemRenderer((Item)itemThaumcraftBackpack, (IItemRenderer)new ItemRendererBackpack(TileEntityBackpack.class));
        }
        if (thaumiumChest != null) {
            thaumiumChestRenderId = ClientProxy.registerTileEntityRenderer(TileEntityThaumiumChest.class, new TileEntityReinforcedChestRenderer());
        }
    }

    @Override
    public void postInitialize() {
        this.addItemAspects();
        this.addEntityAspects();
        if (thaumcraftBackpack != null || thaumiumChest != null) {
            ArrayList<ResearchPage> pages = new ArrayList<ResearchPage>();
            pages.add(new ResearchPage("tc.research_page.betterstorage.magicstorage.1"));
            if (thaumcraftBackpack != null) {
                pages.add(new ResearchPage(thaumcraftBackpackRecipe));
            }
            if (thaumiumChest != null) {
                pages.add(new ResearchPage(thaumiumChestRecipe));
            }
            ResearchItem researchItem = new ResearchItem("betterstorage.magicstorage", "ARTIFICE", ThaumcraftAddon.createAspectList(Aspect.VOID, 8, Aspect.MAGIC, 5, Aspect.EXCHANGE, 5), 2, 2, 2, new ItemStack((Item)(thaumcraftBackpack != null ? itemThaumcraftBackpack : Item.func_150898_a((Block)thaumiumChest)))).setPages(pages.toArray(new ResearchPage[0])).setParents(new String[]{"ENCHFABRIC"}).setParentsHidden(new String[]{"INFUSION"}).setConcealed().registerResearchItem();
        }
    }
}

