/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.addon.minetweaker;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.mcft.copy.betterstorage.addon.minetweaker.MTHelper;
import net.mcft.copy.betterstorage.addon.minetweaker.MTShapedStationRecipe;
import net.mcft.copy.betterstorage.addon.minetweaker.MTShapelessStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.betterstorage.CraftingStation")
public class MTCraftingStation {
    @ZenMethod
    public static void addShaped(IItemStack[] output, IIngredient[][] input, @Optional int experience, @Optional int craftingTime) {
        MTCraftingStation.addShaped(output, input, experience, craftingTime, false);
    }

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] input, @Optional int experience, @Optional int craftingTime) {
        MTCraftingStation.addShaped(new IItemStack[]{null, null, null, null, output}, input, experience, craftingTime);
    }

    @ZenMethod
    public static void addShapedMirrored(IItemStack[] output, IIngredient[][] input, @Optional int experience, @Optional int craftingTime) {
        MTCraftingStation.addShaped(output, input, experience, craftingTime, true);
    }

    @ZenMethod
    public static void addShapedMirrored(IItemStack output, IIngredient[][] input, @Optional int experience, @Optional int craftingTime) {
        MTCraftingStation.addShapedMirrored(new IItemStack[]{null, null, null, null, output}, input, experience, craftingTime);
    }

    private static void addShaped(IItemStack[] output, IIngredient[][] input, int experience, int craftingTime, boolean mirrored) {
        ItemStack[] recipeOutput = MTHelper.toStacks(output);
        MTShapedStationRecipe recipe = new MTShapedStationRecipe(input, recipeOutput, experience, craftingTime, mirrored);
        MineTweakerAPI.apply((IUndoableAction)new UndoableRecipeAddAction(recipe, recipeOutput));
    }

    @ZenMethod
    public static void addShapeless(IItemStack[] output, IIngredient[] input, @Optional int experience, @Optional int craftingTime) {
        ItemStack[] recipeOutput = MTHelper.toStacks(output);
        MTShapelessStationRecipe recipe = new MTShapelessStationRecipe(input, recipeOutput, experience, craftingTime);
        MineTweakerAPI.apply((IUndoableAction)new UndoableRecipeAddAction(recipe, recipeOutput));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] input, @Optional int experience, @Optional int craftingTime) {
        MTCraftingStation.addShapeless(new IItemStack[]{null, null, null, null, output}, input, experience, craftingTime);
    }

    private static class UndoableRecipeAddAction
    implements IUndoableAction {
        private final IStationRecipe recipe;
        private String desc;

        public UndoableRecipeAddAction(IStationRecipe recipe, ItemStack[] output) {
            this.recipe = recipe;
            this.desc = "[ ";
            for (int i = 0; i < output.length; ++i) {
                if (output[i] == null) continue;
                this.desc = this.desc + output[i].func_82833_r();
                if (i >= output.length - 1) continue;
                this.desc = this.desc + ", ";
            }
            this.desc = this.desc + " ]";
        }

        public String describe() {
            return "Adding crafting station recipe for " + this.desc;
        }

        public String describeUndo() {
            return "Removing crafting station recipe for " + this.desc;
        }

        public boolean canUndo() {
            return true;
        }

        public void apply() {
            BetterStorageCrafting.addStationRecipe(this.recipe);
        }

        public void undo() {
            BetterStorageCrafting.recipes.remove(this.recipe);
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

