/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.api.IContainerItem;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class StackUtils {
    private StackUtils() {
    }

    public static NBTBase getTag(ItemStack stack, String ... tags) {
        if (!stack.hasTagCompound()) {
            return null;
        }
        String tag = null;
        NBTTagCompound compound = stack.getTagCompound();
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (!compound.hasKey(tag)) {
                return null;
            }
            if (i == tags.length - 1) break;
            compound = compound.getCompoundTag(tag);
        }
        return compound.getTag(tag);
    }

    public static String getType(ItemStack stack, String ... tags) {
        NBTBase tag = StackUtils.getTag(stack, tags);
        return tag != null ? NBTBase.NBTTypes[tag.getId()] : null;
    }

    public static <T> T get(ItemStack stack, T defaultValue, String ... tags) {
        NBTBase tag = StackUtils.getTag(stack, tags);
        return tag != null ? NbtUtils.getTagValue(tag) : defaultValue;
    }

    public static void set(ItemStack stack, NBTBase nbtTag, String ... tags) {
        NBTTagCompound compound;
        String tag = null;
        if (!stack.hasTagCompound()) {
            compound = new NBTTagCompound();
            stack.setTagCompound(compound);
        } else {
            compound = stack.getTagCompound();
        }
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (i == tags.length - 1) break;
            if (!compound.hasKey(tag)) {
                NBTTagCompound newCompound = new NBTTagCompound();
                compound.setTag(tag, (NBTBase)newCompound);
                compound = newCompound;
                continue;
            }
            compound = compound.getCompoundTag(tag);
        }
        compound.setTag(tag, nbtTag);
    }

    public static <T> void set(ItemStack stack, T value, String ... tags) {
        StackUtils.set(stack, NbtUtils.createTag(value), tags);
    }

    public static boolean has(ItemStack stack, String ... tags) {
        if (!stack.hasTagCompound()) {
            return false;
        }
        String tag = null;
        NBTTagCompound compound = stack.getTagCompound();
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (!compound.hasKey(tag)) {
                return false;
            }
            if (i == tags.length - 1) break;
            compound = compound.getCompoundTag(tag);
        }
        return compound.hasKey(tag);
    }

    public static void remove(ItemStack stack, String ... tags) {
        if (!stack.hasTagCompound()) {
            return;
        }
        String tag = null;
        NBTTagCompound compound = stack.getTagCompound();
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (!compound.hasKey(tag)) {
                return;
            }
            if (i == tags.length - 1) break;
            compound = compound.getCompoundTag(tag);
        }
        compound.removeTag(tag);
    }

    public static ItemStack copyStack(ItemStack stack, int stackSize) {
        return StackUtils.copyStack(stack, stackSize, true);
    }

    public static ItemStack copyStack(ItemStack stack, int stackSize, boolean checkSize) {
        if (stack == null || checkSize && stackSize <= 0) {
            return null;
        }
        ItemStack copy = new ItemStack(stack.getItem(), stackSize, StackUtils.getRealItemDamage(stack));
        if (stack.stackTagCompound != null) {
            copy.stackTagCompound = (NBTTagCompound)stack.stackTagCompound.copy();
        }
        return copy;
    }

    public static boolean matches(Item item1, int damage1, NBTTagCompound data1, Item item2, int damage2, NBTTagCompound data2) {
        return item1 == item2 && damage1 == damage2 && StackUtils.nbtEquals(data1, data2);
    }

    public static boolean nbtEquals(NBTTagCompound nbt1, NBTTagCompound nbt2) {
        return nbt1 == nbt2 || nbt1 != null && nbt2 != null && nbt1.equals((Object)nbt2);
    }

    public static boolean matches(ItemStack stack1, ItemStack stack2, boolean matchNBT) {
        return stack1 == null ? stack2 == null : stack2 != null && StackUtils.matches(stack1.getItem(), StackUtils.getRealItemDamage(stack1), matchNBT ? stack1.getTagCompound() : null, stack2.getItem(), StackUtils.getRealItemDamage(stack2), matchNBT ? stack2.getTagCompound() : null);
    }

    public static boolean matches(ItemStack stack1, ItemStack stack2) {
        return StackUtils.matches(stack1, stack2, true);
    }

    public static Map<Integer, StackEnchantment> getEnchantments(ItemStack stack) {
        NBTTagList list;
        HashMap<Integer, StackEnchantment> enchantments = new HashMap<Integer, StackEnchantment>();
        NBTTagList nBTTagList = list = stack.getItem() == Items.enchanted_book ? Items.enchanted_book.func_92110_g(stack) : stack.getEnchantmentTagList();
        if (list != null) {
            for (int i = 0; i < list.tagCount(); ++i) {
                StackEnchantment ench = new StackEnchantment(stack, list.getCompoundTagAt(i));
                enchantments.put(ench.ench.effectId, ench);
            }
        }
        return enchantments;
    }

    public static boolean isEnchantmentCompatible(ItemStack stack, Collection<StackEnchantment> stackEnchants, StackEnchantment newEnchant) {
        if (!newEnchant.ench.canApply(stack)) {
            return false;
        }
        for (StackEnchantment stackEnch : stackEnchants) {
            if (!(newEnchant.ench == stackEnch.ench ? newEnchant.getLevel() <= stackEnch.getLevel() : !newEnchant.ench.canApplyTogether(stackEnch.ench) || !stackEnch.ench.canApplyTogether(newEnchant.ench))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnchantmentCompatible(ItemStack stack, StackEnchantment newEnchant) {
        return StackUtils.isEnchantmentCompatible(stack, StackUtils.getEnchantments(stack).values(), newEnchant);
    }

    public static int getRealItemDamage(ItemStack stack) {
        return Items.emerald.getDamage(stack);
    }

    public static int calcNumStacks(ItemStack stack, int count) {
        int maxStackSize = stack.getMaxStackSize();
        return (count + maxStackSize - 1) / maxStackSize;
    }

    public static int calcNumStacks(ItemStack stack) {
        return StackUtils.calcNumStacks(stack, stack.stackSize);
    }

    public static int stackItems(ItemStack[] contents, List<ItemStack> items) {
        int numStacks = 0;
        block0: for (int i = 0; i < contents.length; ++i) {
            ItemStack contentStack = contents[i];
            if (contentStack == null) continue;
            ++numStacks;
            for (ItemStack itemsStack : items) {
                if (!StackUtils.matches(contentStack, itemsStack)) continue;
                itemsStack.stackSize += contentStack.stackSize;
                continue block0;
            }
            items.add(contentStack);
        }
        return numStacks;
    }

    public static List<ItemStack> stackItems(ItemStack[] contents) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        StackUtils.stackItems(contents, items);
        return items;
    }

    public static ItemStack[] getStackContents(ItemStack stack, int size) {
        ItemStack[] contents = new ItemStack[size];
        NBTTagCompound compound = stack.getTagCompound();
        if (compound != null && compound.hasKey("Items")) {
            NbtUtils.readItems(contents, compound.getTagList("Items", 10));
        }
        return contents;
    }

    public static void setStackContents(ItemStack stack, ItemStack[] contents) {
        StackUtils.set(stack, (NBTBase)NbtUtils.writeItems(contents), "Items");
    }

    public static boolean isEmpty(ItemStack[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isKey(ItemStack stack) {
        return stack != null && stack.getItem() instanceof IKey;
    }

    public static boolean isLock(ItemStack stack) {
        return stack != null && stack.getItem() instanceof ILock;
    }

    public static boolean canBeStoredInContainerItem(ItemStack item) {
        return item != null && item.getItem() instanceof IContainerItem ? ((IContainerItem)item.getItem()).canBeStoredInContainerItem(item) : true;
    }

    public static class StackEnchantment {
        public final ItemStack stack;
        public final Enchantment ench;
        private final NBTTagCompound entry;

        public int getLevel() {
            return this.entry.getShort("lvl");
        }

        public void setLevel(int level) {
            this.entry.setShort("lvl", (short)level);
        }

        public StackEnchantment(ItemStack stack, NBTTagCompound entry) {
            this.stack = stack;
            this.entry = entry;
            this.ench = Enchantment.enchantmentsList[entry.getShort("id")];
        }
    }
}

