/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.stand;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.api.stand.ArmorStandEquipHandler;
import net.mcft.copy.betterstorage.api.stand.BetterStorageArmorStand;
import net.mcft.copy.betterstorage.api.stand.EnumArmorStandRegion;
import net.mcft.copy.betterstorage.api.stand.IArmorStand;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;

public class TileEntityArmorStand
extends TileEntityContainer
implements IArmorStand {
    private Map<EnumArmorStandRegion, Map<ArmorStandEquipHandler, ItemStack>> equipment = new HashMap<EnumArmorStandRegion, Map<ArmorStandEquipHandler, ItemStack>>();
    public int rotation = 0;

    public TileEntityArmorStand() {
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            this.equipment.put(region, new HashMap());
        }
    }

    private void clearItems() {
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            this.equipment.get((Object)region).clear();
        }
    }

    @Override
    public ItemStack getItem(ArmorStandEquipHandler handler) {
        return this.equipment.get((Object)handler.region).get(handler);
    }

    @Override
    public void setItem(ArmorStandEquipHandler handler, ItemStack item) {
        Map<ArmorStandEquipHandler, ItemStack> items = this.equipment.get((Object)handler.region);
        if (item == null) {
            items.remove(handler);
        } else {
            items.put(handler, item);
        }
        if (this.worldObj != null) {
            this.markForUpdate();
            this.markDirty();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    @Override
    public String getName() {
        return "container.betterstorage.armorStand";
    }

    @Override
    public boolean canSetCustomTitle() {
        return false;
    }

    @Override
    protected int getSizeContents() {
        return 0;
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.rotation = Math.round((player.rotationYawHead + 180.0f) * 16.0f / 360.0f);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.worldObj.isRemote) {
            return true;
        }
        int slot = Math.max(0, Math.min(3, (int)(hitY * 2.0f)));
        EnumArmorStandRegion region = EnumArmorStandRegion.values()[slot];
        for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
            ItemStack item = this.getItem(handler);
            if (player.isSneaking()) {
                ItemStack equipped = handler.getEquipment(player);
                if (item == null && equipped == null || item != null && !handler.isValidItem(player, item) || equipped != null && !handler.isValidItem(player, equipped) || !handler.canSetEquipment(player, item)) continue;
                this.setItem(handler, equipped);
                handler.setEquipment(player, item);
                continue;
            }
            ItemStack holding = player.getCurrentEquippedItem();
            if (item == null && holding == null || holding != null && !handler.isValidItem(player, holding)) continue;
            this.setItem(handler, holding);
            player.setCurrentItemOrArmor(0, item);
            break;
        }
        return true;
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        int slot = Math.max(0, Math.min(3, (int)((target.hitVec.yCoord - (double)this.yCoord) * 2.0)));
        EnumArmorStandRegion region = EnumArmorStandRegion.values()[slot];
        for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
            ItemStack item = this.getItem(handler);
            if (item == null) continue;
            return item;
        }
        return block;
    }

    @Override
    public void dropContents() {
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
                ItemStack item = this.getItem(handler);
                if (item == null) continue;
                WorldUtils.dropStackFromBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, item);
            }
        }
        this.clearItems();
    }

    @Override
    protected int getComparatorSignalStengthInternal() {
        int count = 0;
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
                if (this.getItem(handler) == null) continue;
                ++count;
            }
        }
        return count;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        this.write(compound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.read(packet.func_148857_g());
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.read(compound);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        this.write(compound);
    }

    public void read(NBTTagCompound compound) {
        this.rotation = compound.getByte("rotation");
        this.clearItems();
        NBTBase itemsTag = compound.getTag("Items");
        if (itemsTag instanceof NBTTagList) {
            NBTTagList items = (NBTTagList)itemsTag;
            for (int i = 0; i < items.tagCount(); ++i) {
                EnumArmorStandRegion region;
                ArmorStandEquipHandler handler;
                NBTTagCompound item = items.getCompoundTagAt(i);
                int slot = item.getByte("Slot") & 0xFF;
                if (slot < 0 || slot >= EnumArmorStandRegion.values().length || (handler = BetterStorageArmorStand.getEquipHandler(region = EnumArmorStandRegion.values()[slot], "Vanilla")) == null) continue;
                this.setItem(handler, ItemStack.loadItemStackFromNBT((NBTTagCompound)item));
            }
        } else {
            NBTTagCompound items = (NBTTagCompound)itemsTag;
            for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
                NBTTagCompound regionItems = items.getCompoundTag(region.toString());
                for (String id : regionItems.func_150296_c()) {
                    ItemStack item = ItemStack.loadItemStackFromNBT((NBTTagCompound)regionItems.getCompoundTag(id));
                    ArmorStandEquipHandler handler = BetterStorageArmorStand.getEquipHandler(region, id);
                    this.setItem(handler, item);
                }
            }
        }
    }

    public void write(NBTTagCompound compound) {
        compound.setByte("rotation", (byte)this.rotation);
        NBTTagCompound items = new NBTTagCompound();
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            NBTTagCompound regionCompound = new NBTTagCompound();
            for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
                ItemStack item = this.getItem(handler);
                if (item == null) continue;
                regionCompound.setTag(handler.id, (NBTBase)item.writeToNBT(new NBTTagCompound()));
            }
            items.setTag(region.toString(), (NBTBase)regionCompound);
        }
        compound.setTag("Items", (NBTBase)items);
    }
}

